/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.core.events.GenieEventBus;
import com.netflix.genie.web.properties.ZookeeperProperties;
import com.netflix.genie.web.tasks.leader.LeadershipTask;
import com.netflix.genie.web.tasks.leader.LeadershipTasksCoordinator;
import com.netflix.genie.web.tasks.leader.LocalLeader;
import java.util.Collection;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.zookeeper.config.LeaderInitiatorFactoryBean;
import org.springframework.scheduling.TaskScheduler;

@Configuration
public class LeadershipConfig {
    @Bean
    @ConditionalOnBean(value={LeadershipTask.class})
    public LeadershipTasksCoordinator leadershipTasksCoordinator(TaskScheduler taskScheduler, Collection<LeadershipTask> tasks) {
        return new LeadershipTasksCoordinator(taskScheduler, tasks);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.zookeeper.enabled"})
    public LeaderInitiatorFactoryBean leaderInitiatorFactory(CuratorFramework client, ZookeeperProperties zookeeperProperties) {
        LeaderInitiatorFactoryBean factoryBean = new LeaderInitiatorFactoryBean();
        factoryBean.setClient(client);
        factoryBean.setPath(zookeeperProperties.getLeader().getPath());
        factoryBean.setRole("cluster");
        return factoryBean;
    }

    @Bean
    @ConditionalOnProperty(value={"genie.zookeeper.enabled"}, havingValue="false", matchIfMissing=true)
    public LocalLeader localLeader(GenieEventBus genieEventBus, @Value(value="${genie.leader.enabled}") boolean isLeader) {
        return new LocalLeader(genieEventBus, isLeader);
    }
}

