/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.github.fge.jsonpatch.JsonPatch;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.ApplicationStatus;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.core.services.ApplicationService;
import com.netflix.genie.web.hateoas.assemblers.ApplicationResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.CommandResourceAssembler;
import com.netflix.genie.web.hateoas.resources.ApplicationResource;
import com.netflix.genie.web.hateoas.resources.CommandResource;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/applications"})
public class ApplicationRestController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRestController.class);
    private final ApplicationService applicationService;
    private final ApplicationResourceAssembler applicationResourceAssembler;
    private final CommandResourceAssembler commandResourceAssembler;

    @Autowired
    public ApplicationRestController(ApplicationService applicationService, ApplicationResourceAssembler applicationResourceAssembler, CommandResourceAssembler commandResourceAssembler) {
        this.applicationService = applicationService;
        this.applicationResourceAssembler = applicationResourceAssembler;
        this.commandResourceAssembler = commandResourceAssembler;
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createApplication(@RequestBody Application app) throws GenieException {
        log.debug("Called to create new application");
        String id = this.applicationService.createApplication(app);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{id}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllApplications() throws GenieException {
        log.debug("Delete all Applications");
        this.applicationService.deleteAllApplications();
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<ApplicationResource> getApplications(@RequestParam(value="name", required=false) String name, @RequestParam(value="user", required=false) String user, @RequestParam(value="status", required=false) Set<String> statuses, @RequestParam(value="tag", required=false) Set<String> tags, @RequestParam(value="type", required=false) String type, @PageableDefault(sort={"updated"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<Application> assembler) throws GenieException {
        log.debug("Called [name | user | status | tags | type | pageable]");
        log.debug("{} | {} | {} | {} | | {} | {}", new Object[]{name, user, statuses, tags, type, page});
        EnumSet<ApplicationStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(ApplicationStatus.class);
            for (String status : statuses) {
                enumStatuses.add(ApplicationStatus.parse((String)status));
            }
        }
        Link self = ControllerLinkBuilder.linkTo(((ApplicationRestController)ControllerLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getApplications(name, user, statuses, tags, type, page, assembler)).withSelfRel();
        return assembler.toResource(this.applicationService.getApplications(name, user, enumStatuses, tags, type, page), (ResourceAssembler)this.applicationResourceAssembler, self);
    }

    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ApplicationResource getApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called to get Application for id {}", (Object)id);
        return this.applicationResourceAssembler.toResource(this.applicationService.getApplication(id));
    }

    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateApplication(@PathVariable(value="id") String id, @RequestBody Application updateApp) throws GenieException {
        log.debug("called to update application {} with info {}", (Object)id, (Object)updateApp);
        this.applicationService.updateApplication(id, updateApp);
    }

    @PatchMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchApplication(@PathVariable(value="id") String id, @RequestBody JsonPatch patch) throws GenieException {
        log.debug("Called to patch application {} with patch {}", (Object)id, (Object)patch);
        this.applicationService.patchApplication(id, patch);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Delete an application with id {}", (Object)id);
        this.applicationService.deleteApplication(id);
    }

    @PostMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addConfigsToApplication(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.debug("Called with id {} and config {}", (Object)id, configs);
        this.applicationService.addConfigsToApplication(id, configs);
    }

    @GetMapping(value={"/{id}/configs"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getConfigsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.applicationService.getConfigsForApplication(id);
    }

    @PutMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfigsForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.debug("Called with id {} and configs {}", (Object)id, configs);
        this.applicationService.updateConfigsForApplication(id, configs);
    }

    @DeleteMapping(value={"/{id}/configs"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllConfigsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.applicationService.removeAllConfigsForApplication(id);
    }

    @PostMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addDependenciesForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.debug("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.applicationService.addDependenciesForApplication(id, dependencies);
    }

    @GetMapping(value={"/{id}/dependencies"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getDependenciesForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.applicationService.getDependenciesForApplication(id);
    }

    @PutMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDependenciesForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.debug("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.applicationService.updateDependenciesForApplication(id, dependencies);
    }

    @DeleteMapping(value={"/{id}/dependencies"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllDependenciesForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.applicationService.removeAllDependenciesForApplication(id);
    }

    @PostMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addTagsForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.debug("Called with id {} and config {}", (Object)id, tags);
        this.applicationService.addTagsForApplication(id, tags);
    }

    @GetMapping(value={"/{id}/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getTagsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.applicationService.getTagsForApplication(id);
    }

    @PutMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTagsForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.debug("Called with id {} and tags {}", (Object)id, tags);
        this.applicationService.updateTagsForApplication(id, tags);
    }

    @DeleteMapping(value={"/{id}/tags"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllTagsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        this.applicationService.removeAllTagsForApplication(id);
    }

    @DeleteMapping(value={"/{id}/tags/{tag}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeTagForApplication(@PathVariable(value="id") String id, @PathVariable(value="tag") String tag) throws GenieException {
        log.debug("Called with id {} and tag {}", (Object)id, (Object)tag);
        this.applicationService.removeTagForApplication(id, tag);
    }

    @GetMapping(value={"/{id}/commands"}, produces={"application/hal+json"})
    public Set<CommandResource> getCommandsForApplication(@PathVariable(value="id") String id, @RequestParam(value="status", required=false) Set<String> statuses) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        EnumSet<CommandStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(CommandStatus.class);
            for (String status : statuses) {
                enumStatuses.add(CommandStatus.parse((String)status));
            }
        }
        return this.applicationService.getCommandsForApplication(id, enumStatuses).stream().map(this.commandResourceAssembler::toResource).collect(Collectors.toSet());
    }
}

