/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieUserLimitExceededException;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GenieExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(GenieExceptionMapper.class);
    private static final String NEW_LINE = "\n";
    private final Registry registry;
    private final Id exceptionCounterId;

    @Autowired
    public GenieExceptionMapper(Registry registry) {
        this.registry = registry;
        this.exceptionCounterId = registry.createId("genie.web.controllers.exception");
    }

    @ExceptionHandler(value={GenieException.class})
    public void handleGenieException(HttpServletResponse response, GenieException e) throws IOException {
        this.countException((Exception)((Object)e));
        log.error(e.getLocalizedMessage(), (Throwable)e);
        response.sendError(e.getErrorCode(), e.getLocalizedMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public void handleConstraintViolation(HttpServletResponse response, ConstraintViolationException cve) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (cve.getConstraintViolations() != null) {
            for (ConstraintViolation cv : cve.getConstraintViolations()) {
                if (builder.length() != 0) {
                    builder.append(NEW_LINE);
                }
                builder.append(cv.getMessage());
            }
        }
        this.countException((Exception)((Object)cve));
        log.error(cve.getLocalizedMessage(), (Throwable)cve);
        response.sendError(HttpStatus.PRECONDITION_FAILED.value(), builder.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public void handleMethodArgumentNotValidException(HttpServletResponse response, MethodArgumentNotValidException e) throws IOException {
        this.countException((Exception)e);
        log.error(e.getMessage(), (Throwable)e);
        response.sendError(HttpStatus.PRECONDITION_FAILED.value(), e.getMessage());
    }

    private void countException(Exception e) {
        Id taggedId = this.exceptionCounterId.withTag("exceptionClass", e.getClass().getCanonicalName());
        if (e instanceof GenieUserLimitExceededException) {
            GenieUserLimitExceededException userLimitExceededException = (GenieUserLimitExceededException)e;
            taggedId = taggedId.withTag("user", userLimitExceededException.getUser()).withTag("limit", userLimitExceededException.getExceededLimitName());
        }
        this.registry.counter(taggedId).increment();
    }
}

