/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.aspect;

import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.core.properties.DataServiceRetryProperties;
import java.util.Map;
import javax.validation.ConstraintViolationException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataServiceRetryAspect
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(DataServiceRetryAspect.class);
    private final RetryTemplate retryTemplate = new RetryTemplate();

    @Autowired
    public DataServiceRetryAspect(DataServiceRetryProperties dataServiceRetryProperties) {
        this.retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(dataServiceRetryProperties.getNoOfRetries(), (Map)new ImmutableMap.Builder().put(CannotGetJdbcConnectionException.class, (Object)true).put(CannotAcquireLockException.class, (Object)true).put(DeadlockLoserDataAccessException.class, (Object)true).put(OptimisticLockingFailureException.class, (Object)true).put(PessimisticLockingFailureException.class, (Object)true).put(ConcurrencyFailureException.class, (Object)true).put(QueryTimeoutException.class, (Object)true).put(TransientDataAccessResourceException.class, (Object)true).put(JpaSystemException.class, (Object)true).build()));
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(dataServiceRetryProperties.getInitialInterval());
        backOffPolicy.setMaxInterval(dataServiceRetryProperties.getMaxInterval());
        this.retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
    }

    public void setRetryListeners(RetryListener[] retryListeners) {
        this.retryTemplate.setListeners(retryListeners);
    }

    @Around(value="com.netflix.genie.web.aspect.SystemArchitecture.dataOperation()")
    public Object profile(ProceedingJoinPoint pjp) throws GenieException {
        try {
            return this.retryTemplate.execute(context -> pjp.proceed());
        }
        catch (GenieException | ConstraintViolationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GenieServerException("Failed to execute data service method", e);
        }
    }

    public int getOrder() {
        return 0;
    }
}

