/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.aspect;

import com.google.common.collect.Maps;
import com.netflix.genie.core.util.MetricsUtils;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class HealthCheckMetricsAspect {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckMetricsAspect.class);
    private static final String HEALTH_ENDPOINT_TIMER_NAME = "genie.health.endpoint.timer";
    private static final String HEALTH_INDICATOR_TIMER_METRIC_NAME = "genie.health.indicator.timer";
    private static final String HEALTH_INDICATOR_COUNTER_METRIC_NAME = "genie.health.indicator.counter";
    private static final String HEALTH_FAILURES_COUNTER_METRIC_NAME = "genie.health.failure.counter";
    private static final String HEALTH_INDICATOR_CLASS_TAG_NAME = "healthIndicatorClass";
    private static final String HEALTH_INDICATOR_NAME_TAG_NAME = "healthIndicatorName";
    private final Registry registry;
    private final Id healthEndpointTimerId;
    private final Id healthIndicatorTimerId;
    private final Id healthIndicatorCounterId;
    private final Id healthIndicatorFailureCounterId;

    @Autowired
    public HealthCheckMetricsAspect(Registry registry) {
        this.registry = registry;
        this.healthEndpointTimerId = registry.createId(HEALTH_ENDPOINT_TIMER_NAME);
        this.healthIndicatorTimerId = registry.createId(HEALTH_INDICATOR_TIMER_METRIC_NAME);
        this.healthIndicatorCounterId = registry.createId(HEALTH_INDICATOR_COUNTER_METRIC_NAME);
        this.healthIndicatorFailureCounterId = registry.createId(HEALTH_FAILURES_COUNTER_METRIC_NAME);
    }

    @Around(value="execution(  org.springframework.boot.actuate.health.Health  org.springframework.boot.actuate.endpoint.HealthEndpoint.invoke())")
    public Health healthEndpointInvokeMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
        Health health;
        long start = System.nanoTime();
        Status status = Status.UNKNOWN;
        Map tags = MetricsUtils.newSuccessTagsMap();
        try {
            health = (Health)joinPoint.proceed(joinPoint.getArgs());
            status = health.getStatus();
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException((Map)tags, (Throwable)t);
            throw t;
        }
        finally {
            long turnaround = System.nanoTime() - start;
            tags.put("status", status.toString());
            log.debug("HealthEndpoint.invoke() completed in {} ns", (Object)turnaround);
            this.registry.timer(this.healthEndpointTimerId.withTags(tags)).record(turnaround, TimeUnit.NANOSECONDS);
        }
        return health;
    }

    @Around(value="execution(  org.springframework.boot.actuate.health.Health  org.springframework.boot.actuate.health.HealthIndicator.health())")
    public Health healthIndicatorHealthMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
        Health h;
        long start = System.nanoTime();
        Throwable throwable = null;
        try {
            h = (Health)joinPoint.proceed(joinPoint.getArgs());
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            long turnaround = System.nanoTime() - start;
            this.recordHealthIndicatorTurnaround(turnaround, joinPoint, throwable);
        }
        return h;
    }

    @Around(value="execution(  void org.springframework.boot.actuate.health.AbstractHealthIndicator.doHealthCheck(      org.springframework.boot.actuate.health.Health.Builder  ))")
    public void abstractHealthIndicatorDoHealthCheckMonitor(ProceedingJoinPoint joinPoint) throws Throwable {
        long start = System.nanoTime();
        Throwable throwable = null;
        try {
            joinPoint.proceed(joinPoint.getArgs());
        }
        catch (Throwable t) {
            throwable = t;
            throw t;
        }
        finally {
            long turnaround = System.nanoTime() - start;
            this.recordHealthIndicatorTurnaround(turnaround, joinPoint, throwable);
        }
    }

    private void recordHealthIndicatorTurnaround(long turnaround, ProceedingJoinPoint joinPoint, @Nullable Throwable throwable) {
        log.debug("{} completed in {} ns (exception: {})", new Object[]{joinPoint.getTarget().getClass().getSimpleName(), turnaround, throwable != null ? throwable.getClass().getSimpleName() : "none"});
        Map tags = throwable == null ? MetricsUtils.newSuccessTagsMap() : MetricsUtils.newFailureTagsMapForException((Throwable)throwable);
        tags.put(HEALTH_INDICATOR_CLASS_TAG_NAME, joinPoint.getTarget().getClass().getSimpleName());
        this.registry.timer(this.healthIndicatorTimerId.withTags(tags)).record(turnaround, TimeUnit.NANOSECONDS);
    }

    @Before(value="execution(  java.util.Map<String, Object>   org.springframework.boot.actuate.health.AbstractHealthAggregator.aggregateDetails(    java.util.Map<String, org.springframework.boot.actuate.health.Health>  ))")
    public void abstractHealthAggregatorAggregateDetailsMonitor(JoinPoint joinPoint) {
        Map healthDetailsMap;
        try {
            Map map;
            healthDetailsMap = map = (Map)joinPoint.getArgs()[0];
        }
        catch (Throwable t) {
            log.warn("Failed to cast AbstractHealthAggregator health details argument: {}", (Object)joinPoint.getArgs(), (Object)t);
            return;
        }
        healthDetailsMap.forEach((name, health) -> {
            HashMap tags = Maps.newHashMap();
            tags.put(HEALTH_INDICATOR_NAME_TAG_NAME, name);
            tags.put("status", health.getStatus().getCode());
            boolean isUp = Status.UP.equals((Object)health.getStatus());
            this.registry.counter(this.healthIndicatorCounterId.withTags((Map)tags)).increment();
            this.registry.counter(this.healthIndicatorFailureCounterId.withTags((Map)tags)).increment(isUp ? 0L : 1L);
        });
    }
}

