/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.google.common.collect.Lists;
import com.netflix.genie.core.properties.JobsProperties;
import com.netflix.genie.web.resources.handlers.GenieResourceHttpRequestHandler;
import com.netflix.genie.web.resources.writers.DefaultDirectoryWriter;
import com.netflix.genie.web.resources.writers.DirectoryWriter;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class MvcConfig
extends WebMvcConfigurerAdapter {
    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseRegisteredSuffixPatternMatch(Boolean.valueOf(true));
    }

    @Bean
    @ConditionalOnMissingBean
    public ResourceLoader resourceLoader() {
        return new DefaultResourceLoader();
    }

    @Bean
    @ConditionalOnMissingBean
    public String hostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @Bean(name={"genieRestTemplate"})
    public RestTemplate restTemplate(@Value(value="${genie.http.connect.timeout:2000}") int httpConnectTimeout, @Value(value="${genie.http.read.timeout:10000}") int httpReadTimeout) {
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setConnectTimeout(httpConnectTimeout);
        factory.setReadTimeout(httpReadTimeout);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Bean(name={"genieRetryTemplate"})
    public RetryTemplate retryTemplate(@Value(value="${genie.retry.noOfRetries:5}") int noOfRetries, @Value(value="${genie.retry.initialInterval:10000}") int initialInterval, @Value(value="${genie.retry.maxInterval:60000}") int maxInterval) {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(noOfRetries, Collections.singletonMap(Exception.class, true)));
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval((long)initialInterval);
        backOffPolicy.setMaxInterval((long)maxInterval);
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return retryTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public DirectoryWriter directoryWriter() {
        return new DefaultDirectoryWriter();
    }

    @Bean
    @ConditionalOnMissingBean
    public Resource jobsDir(ResourceLoader resourceLoader, JobsProperties jobsProperties) throws IOException {
        File file;
        Resource jobsDirResource;
        String jobsDirLocation = jobsProperties.getLocations().getJobs();
        Resource tmpJobsDirResource = resourceLoader.getResource(jobsDirLocation);
        if (tmpJobsDirResource.exists() && !tmpJobsDirResource.getFile().isDirectory()) {
            throw new IllegalStateException(jobsDirLocation + " exists but isn't a directory. Unable to continue");
        }
        String slash = "/";
        String localJobsDir = jobsDirLocation;
        if (!jobsDirLocation.endsWith("/")) {
            localJobsDir = localJobsDir + "/";
        }
        if (!(jobsDirResource = resourceLoader.getResource(localJobsDir)).exists() && !(file = jobsDirResource.getFile()).mkdirs()) {
            throw new IllegalStateException("Unable to create jobs directory " + jobsDirLocation + " and it doesn't exist.");
        }
        return jobsDirResource;
    }

    @Bean
    @ConditionalOnMissingBean
    public GenieResourceHttpRequestHandler genieResourceHttpRequestHandler(DirectoryWriter directoryWriter, ApplicationContext context, Resource jobsDir) {
        GenieResourceHttpRequestHandler handler = new GenieResourceHttpRequestHandler(directoryWriter);
        handler.setApplicationContext(context);
        handler.setLocations(Lists.newArrayList((Object[])new Resource[]{jobsDir}));
        return handler;
    }

    @Bean
    public CharacterEncodingFilter characterEncodingFilter() {
        CharacterEncodingFilter characterEncodingFilter = new CharacterEncodingFilter();
        characterEncodingFilter.setEncoding(StandardCharsets.UTF_8.name());
        characterEncodingFilter.setForceEncoding(true);
        return characterEncodingFilter;
    }
}

