/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.repository.configuration.EnableRedisRepositories;

@Configuration
@ConditionalOnProperty(value={"genie.redis.enabled"})
@Import(value={RedisAutoConfiguration.class})
public class RedisConfig {
    private static final Logger log = LoggerFactory.getLogger(RedisConfig.class);

    @PostConstruct
    public void postConstruct() {
        log.info("Redis configuration is ENABLED");
    }

    @Configuration
    @ConditionalOnProperty(name={"genie.redis.enabled", "spring.data.redis.repositories.enabled"}, havingValue="true", matchIfMissing=true)
    @EnableRedisRepositories(value={"com.netflix.genie"})
    public static class EnableRedisRepositoryConfig {
    }
}

