/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.ClusterRestController;
import com.netflix.genie.web.hateoas.resources.ClusterResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class ClusterResourceAssembler
implements ResourceAssembler<Cluster, ClusterResource> {
    public ClusterResource toResource(Cluster cluster) {
        String id = (String)cluster.getId().orElseThrow(IllegalArgumentException::new);
        ClusterResource clusterResource = new ClusterResource(cluster);
        try {
            clusterResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((ClusterRestController)ControllerLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getCluster(id))).withSelfRel());
            clusterResource.add(ControllerLinkBuilder.linkTo(((ClusterRestController)ControllerLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getCommandsForCluster(id, null)).withRel("commands"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return clusterResource;
    }
}

