/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security;

import com.netflix.genie.web.security.x509.X509UserDetailsService;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;

public final class SecurityUtils {
    private static final String ADMIN_ROLE = "ADMIN";
    private static final String USER_ROLE = "USER";
    private static final String APPLICATIONS_API_REGEX = "/api/.*/applications.*";
    private static final String CLUSTERS_API_REGEX = "/api/.*/clusters.*";
    private static final String COMMANDS_API_REGEX = "/api/.*/commands.*";

    protected SecurityUtils() {
    }

    public static void buildAPIHttpSecurity(@NotNull HttpSecurity http, @NotNull X509UserDetailsService x509UserDetailsService, @NotBlank String actuatorEndpoint) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.regexMatcher("(/api/.*)").authorizeRequests().regexMatchers(HttpMethod.DELETE, new String[]{APPLICATIONS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.PATCH, new String[]{APPLICATIONS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.POST, new String[]{APPLICATIONS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.PUT, new String[]{APPLICATIONS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.DELETE, new String[]{CLUSTERS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.PATCH, new String[]{CLUSTERS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.POST, new String[]{CLUSTERS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.PUT, new String[]{CLUSTERS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.DELETE, new String[]{COMMANDS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.PATCH, new String[]{COMMANDS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.POST, new String[]{COMMANDS_API_REGEX})).hasRole(ADMIN_ROLE).regexMatchers(HttpMethod.PUT, new String[]{COMMANDS_API_REGEX})).hasRole(ADMIN_ROLE).anyRequest()).hasRole(USER_ROLE).and()).x509().authenticationUserDetailsService((AuthenticationUserDetailsService)x509UserDetailsService).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER).and()).requestCache().requestCache((RequestCache)new NullRequestCache()).and()).csrf().disable();
    }
}

