/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.oauth2.pingfederate;

import com.netflix.genie.web.security.oauth2.pingfederate.PingFederateRemoteTokenServices;
import com.netflix.genie.web.security.oauth2.pingfederate.PingFederateSecurityConditions;
import com.netflix.genie.web.security.oauth2.pingfederate.PingFederateUserAuthenticationConverter;
import com.netflix.spectator.api.Registry;
import javax.validation.constraints.NotNull;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;

@Configuration
@Conditional(value={PingFederateSecurityConditions.PingFederateRemoteEnabled.class})
public class PingFederateRemoteConfig {
    @Bean
    public PingFederateUserAuthenticationConverter pingFederateUserAuthenticationConverter() {
        return new PingFederateUserAuthenticationConverter();
    }

    @Bean
    public DefaultAccessTokenConverter defaultAccessTokenConverter(@NotNull UserAuthenticationConverter userAuthenticationConverter) {
        DefaultAccessTokenConverter converter = new DefaultAccessTokenConverter();
        converter.setUserTokenConverter(userAuthenticationConverter);
        return converter;
    }

    @Bean
    @Primary
    public PingFederateRemoteTokenServices pingFederateTokenServices(DefaultAccessTokenConverter converter, ResourceServerProperties resourceServerProperties, Registry registry) {
        return new PingFederateRemoteTokenServices(resourceServerProperties, (AccessTokenConverter)converter, registry);
    }
}

