/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.security.saml;

import com.google.common.collect.Lists;
import com.netflix.genie.web.security.saml.SAMLProperties;
import com.netflix.genie.web.security.x509.X509UserDetailsService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import javax.servlet.Filter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.saml.SAMLAuthenticationProvider;
import org.springframework.security.saml.SAMLBootstrap;
import org.springframework.security.saml.SAMLDiscovery;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLLogoutFilter;
import org.springframework.security.saml.SAMLLogoutProcessingFilter;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.SAMLWebSSOHoKProcessingFilter;
import org.springframework.security.saml.context.SAMLContextProviderImpl;
import org.springframework.security.saml.context.SAMLContextProviderLB;
import org.springframework.security.saml.key.JKSKeyManager;
import org.springframework.security.saml.key.KeyManager;
import org.springframework.security.saml.log.SAMLDefaultLogger;
import org.springframework.security.saml.metadata.CachingMetadataManager;
import org.springframework.security.saml.metadata.ExtendedMetadata;
import org.springframework.security.saml.metadata.ExtendedMetadataDelegate;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.saml.parser.ParserPoolHolder;
import org.springframework.security.saml.processor.HTTPArtifactBinding;
import org.springframework.security.saml.processor.HTTPPAOS11Binding;
import org.springframework.security.saml.processor.HTTPPostBinding;
import org.springframework.security.saml.processor.HTTPRedirectDeflateBinding;
import org.springframework.security.saml.processor.HTTPSOAP11Binding;
import org.springframework.security.saml.processor.SAMLBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.processor.SAMLProcessorImpl;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;
import org.springframework.security.saml.util.VelocityFactory;
import org.springframework.security.saml.websso.ArtifactResolutionProfile;
import org.springframework.security.saml.websso.ArtifactResolutionProfileImpl;
import org.springframework.security.saml.websso.SingleLogoutProfile;
import org.springframework.security.saml.websso.SingleLogoutProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfile;
import org.springframework.security.saml.websso.WebSSOProfileConsumer;
import org.springframework.security.saml.websso.WebSSOProfileConsumerHoKImpl;
import org.springframework.security.saml.websso.WebSSOProfileConsumerImpl;
import org.springframework.security.saml.websso.WebSSOProfileECPImpl;
import org.springframework.security.saml.websso.WebSSOProfileImpl;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@ConditionalOnProperty(value={"genie.security.saml.enabled"})
@Configuration
@Order(value=5)
public class SAMLConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SAMLConfig.class);
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private X509UserDetailsService x509UserDetailsService;
    @Autowired
    private SAMLProperties samlProperties;

    @Bean
    public static SAMLBootstrap samlBootstrap() {
        return new SAMLBootstrap();
    }

    @Bean
    public VelocityEngine velocityEngine() {
        return VelocityFactory.getEngine();
    }

    @Bean(initMethod="initialize")
    public StaticBasicParserPool parserPool() {
        return new StaticBasicParserPool();
    }

    @Bean(name={"parserPoolHolder"})
    public ParserPoolHolder parserPoolHolder() {
        return new ParserPoolHolder();
    }

    @Bean
    public MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager() {
        return new MultiThreadedHttpConnectionManager();
    }

    @Bean
    public HttpClient httpClient() {
        return new HttpClient((HttpConnectionManager)this.multiThreadedHttpConnectionManager());
    }

    @Bean
    public SAMLAuthenticationProvider samlAuthenticationProvider(SAMLUserDetailsService samlUserDetailsService) {
        SAMLAuthenticationProvider samlAuthenticationProvider = new SAMLAuthenticationProvider();
        samlAuthenticationProvider.setUserDetails(samlUserDetailsService);
        samlAuthenticationProvider.setForcePrincipalAsString(false);
        return samlAuthenticationProvider;
    }

    @Bean
    public SAMLContextProviderImpl contextProvider(SAMLProperties properties) {
        if (properties.getLoadBalancer() != null) {
            log.info("Using SAMLContextProviderLB implementation of SAMLContextProvider for context provider bean.");
            SAMLContextProviderLB lb = new SAMLContextProviderLB();
            SAMLProperties.LoadBalancer lbProps = properties.getLoadBalancer();
            String scheme = lbProps.getScheme();
            log.info("Setting the load balancer scheme to {}", (Object)scheme);
            lb.setScheme(scheme);
            String serverName = lbProps.getServerName();
            log.info("Setting the load balancer server name to {}", (Object)serverName);
            lb.setServerName(serverName);
            String contextPath = lbProps.getContextPath();
            log.info("Setting the load balancer context path to {}", (Object)contextPath);
            lb.setContextPath(contextPath);
            int serverPort = lbProps.getServerPort();
            log.info("Setting the load balancer port to {}", (Object)serverPort);
            lb.setServerPort(serverPort);
            boolean includeServerPort = lbProps.isIncludeServerPortInRequestURL();
            log.info("Setting whether to include the server port in the request URL to {}", (Object)includeServerPort);
            lb.setIncludeServerPortInRequestURL(includeServerPort);
            return lb;
        }
        log.info("Using SAMLContextProviderImpl implementation of SAMLContextProvider for context provider bean.");
        return new SAMLContextProviderImpl();
    }

    @Bean
    public SAMLDefaultLogger samlLogger() {
        return new SAMLDefaultLogger();
    }

    @Bean
    public WebSSOProfileConsumer webSSOprofileConsumer() {
        return new WebSSOProfileConsumerImpl();
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOprofileConsumer() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    public WebSSOProfile webSSOprofile() {
        return new WebSSOProfileImpl();
    }

    @Bean
    public WebSSOProfileConsumerHoKImpl hokWebSSOProfile() {
        return new WebSSOProfileConsumerHoKImpl();
    }

    @Bean
    public WebSSOProfileECPImpl ecpprofile() {
        return new WebSSOProfileECPImpl();
    }

    @Bean
    public SingleLogoutProfile logoutProfile() {
        return new SingleLogoutProfileImpl();
    }

    @Bean
    public KeyManager keyManager() {
        Resource storeFile = this.resourceLoader.getResource("classpath:" + this.samlProperties.getKeystore().getName());
        HashMap<String, String> passwords = new HashMap<String, String>();
        passwords.put(this.samlProperties.getKeystore().getDefaultKey().getName(), this.samlProperties.getKeystore().getDefaultKey().getPassword());
        return new JKSKeyManager(storeFile, this.samlProperties.getKeystore().getPassword(), passwords, this.samlProperties.getKeystore().getDefaultKey().getName());
    }

    @Bean
    public WebSSOProfileOptions defaultWebSSOProfileOptions() {
        WebSSOProfileOptions webSSOProfileOptions = new WebSSOProfileOptions();
        webSSOProfileOptions.setIncludeScoping(Boolean.valueOf(false));
        return webSSOProfileOptions;
    }

    @Bean
    public SAMLEntryPoint samlEntryPoint() {
        SAMLEntryPoint samlEntryPoint = new SAMLEntryPoint();
        samlEntryPoint.setDefaultProfileOptions(this.defaultWebSSOProfileOptions());
        return samlEntryPoint;
    }

    @Bean
    public ExtendedMetadata extendedMetadata() {
        return new ExtendedMetadata();
    }

    @Bean
    public SAMLDiscovery samlIDPDiscovery() {
        return new SAMLDiscovery();
    }

    @Bean
    @Qualifier(value="idp-ssocircle")
    public ExtendedMetadataDelegate ssoCircleExtendedMetadataProvider(SAMLProperties properties) throws MetadataProviderException {
        Timer backgroundTaskTimer = new Timer(true);
        HTTPMetadataProvider httpMetadataProvider = new HTTPMetadataProvider(backgroundTaskTimer, this.httpClient(), properties.getIdp().getServiceProviderMetadataURL());
        httpMetadataProvider.setParserPool((ParserPool)this.parserPool());
        ExtendedMetadataDelegate extendedMetadataDelegate = new ExtendedMetadataDelegate((MetadataProvider)httpMetadataProvider, this.extendedMetadata());
        extendedMetadataDelegate.setMetadataTrustCheck(true);
        extendedMetadataDelegate.setMetadataRequireSignature(false);
        return extendedMetadataDelegate;
    }

    @Bean
    @Qualifier(value="metadata")
    public CachingMetadataManager metadata(ExtendedMetadataDelegate ssoCircleExtendedMetadataProvider) throws MetadataProviderException {
        return new CachingMetadataManager((List)Lists.newArrayList((Object[])new MetadataProvider[]{ssoCircleExtendedMetadataProvider}));
    }

    @Bean
    public MetadataGenerator metadataGenerator() {
        MetadataGenerator metadataGenerator = new MetadataGenerator();
        metadataGenerator.setEntityId(this.samlProperties.getSp().getEntityId());
        metadataGenerator.setExtendedMetadata(this.extendedMetadata());
        metadataGenerator.setIncludeDiscoveryExtension(false);
        metadataGenerator.setKeyManager(this.keyManager());
        if (this.samlProperties.getSp().getEntityBaseURL() != null) {
            metadataGenerator.setEntityBaseURL(this.samlProperties.getSp().getEntityBaseURL());
        }
        return metadataGenerator;
    }

    @Bean
    public MetadataDisplayFilter metadataDisplayFilter() {
        return new MetadataDisplayFilter();
    }

    @Bean
    public SavedRequestAwareAuthenticationSuccessHandler successRedirectHandler() {
        return new SavedRequestAwareAuthenticationSuccessHandler();
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler authenticationFailureHandler() {
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setUseForward(true);
        failureHandler.setDefaultFailureUrl("/error");
        return failureHandler;
    }

    @Bean
    public SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter() throws Exception {
        SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter = new SAMLWebSSOHoKProcessingFilter();
        samlWebSSOHoKProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successRedirectHandler());
        samlWebSSOHoKProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlWebSSOHoKProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.authenticationFailureHandler());
        return samlWebSSOHoKProcessingFilter;
    }

    @Bean
    public SAMLProcessingFilter samlWebSSOProcessingFilter() throws Exception {
        SAMLProcessingFilter samlWebSSOProcessingFilter = new SAMLProcessingFilter();
        samlWebSSOProcessingFilter.setAuthenticationManager(this.authenticationManager());
        samlWebSSOProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.successRedirectHandler());
        samlWebSSOProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.authenticationFailureHandler());
        return samlWebSSOProcessingFilter;
    }

    @Bean
    public MetadataGeneratorFilter metadataGeneratorFilter() {
        return new MetadataGeneratorFilter(this.metadataGenerator());
    }

    @Bean
    public SimpleUrlLogoutSuccessHandler successLogoutHandler() {
        SimpleUrlLogoutSuccessHandler successLogoutHandler = new SimpleUrlLogoutSuccessHandler();
        successLogoutHandler.setDefaultTargetUrl("/");
        return successLogoutHandler;
    }

    @Bean
    public SecurityContextLogoutHandler logoutHandler() {
        SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();
        logoutHandler.setInvalidateHttpSession(true);
        logoutHandler.setClearAuthentication(true);
        return logoutHandler;
    }

    @Bean
    public SAMLLogoutProcessingFilter samlLogoutProcessingFilter() {
        return new SAMLLogoutProcessingFilter((LogoutSuccessHandler)this.successLogoutHandler(), new LogoutHandler[]{this.logoutHandler()});
    }

    @Bean
    public SAMLLogoutFilter samlLogoutFilter() {
        return new SAMLLogoutFilter((LogoutSuccessHandler)this.successLogoutHandler(), new LogoutHandler[]{this.logoutHandler()}, new LogoutHandler[]{this.logoutHandler()});
    }

    private ArtifactResolutionProfile artifactResolutionProfile() {
        ArtifactResolutionProfileImpl artifactResolutionProfile = new ArtifactResolutionProfileImpl(this.httpClient());
        artifactResolutionProfile.setProcessor((SAMLProcessor)new SAMLProcessorImpl((SAMLBinding)this.soapBinding()));
        return artifactResolutionProfile;
    }

    @Bean
    public HTTPArtifactBinding artifactBinding(ParserPool parserPool, VelocityEngine velocityEngine) {
        return new HTTPArtifactBinding(parserPool, velocityEngine, this.artifactResolutionProfile());
    }

    @Bean
    public HTTPSOAP11Binding soapBinding() {
        return new HTTPSOAP11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPPostBinding httpPostBinding() {
        return new HTTPPostBinding((ParserPool)this.parserPool(), this.velocityEngine());
    }

    @Bean
    public HTTPRedirectDeflateBinding httpRedirectDeflateBinding() {
        return new HTTPRedirectDeflateBinding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPSOAP11Binding httpSOAP11Binding() {
        return new HTTPSOAP11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public HTTPPAOS11Binding httpPAOS11Binding() {
        return new HTTPPAOS11Binding((ParserPool)this.parserPool());
    }

    @Bean
    public SAMLProcessorImpl processor() {
        ArrayList bindings = Lists.newArrayList((Object[])new SAMLBinding[]{this.httpRedirectDeflateBinding(), this.httpPostBinding(), this.artifactBinding((ParserPool)this.parserPool(), this.velocityEngine()), this.httpSOAP11Binding(), this.httpPAOS11Binding()});
        return new SAMLProcessorImpl((Collection)bindings);
    }

    @Bean
    public FilterChainProxy samlFilter() throws Exception {
        ArrayList<DefaultSecurityFilterChain> chains = new ArrayList<DefaultSecurityFilterChain>();
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/login/**"), new Filter[]{this.samlEntryPoint()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/logout/**"), new Filter[]{this.samlLogoutFilter()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/metadata/**"), new Filter[]{this.metadataDisplayFilter()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSO/**"), new Filter[]{this.samlWebSSOProcessingFilter()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSOHoK/**"), new Filter[]{this.samlWebSSOHoKProcessingFilter()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SingleLogout/**"), new Filter[]{this.samlLogoutProcessingFilter()}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/discovery/**"), new Filter[]{this.samlIDPDiscovery()}));
        return new FilterChainProxy(chains);
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.samlEntryPoint());
        http.csrf().disable();
        http.addFilterBefore((Filter)this.metadataGeneratorFilter(), ChannelProcessingFilter.class).addFilterAfter((Filter)this.samlFilter(), BasicAuthenticationFilter.class);
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/**").authorizeRequests().antMatchers(new String[]{"/actuator/**"})).permitAll().antMatchers(new String[]{"/api/**"})).permitAll().antMatchers(new String[]{"/error"})).permitAll().antMatchers(new String[]{"/saml/**"})).permitAll().anyRequest()).authenticated().and()).x509().authenticationUserDetailsService((AuthenticationUserDetailsService)this.x509UserDetailsService);
        http.logout().logoutSuccessUrl("/");
    }

    void setSamlProperties(SAMLProperties samlProperties) {
        this.samlProperties = samlProperties;
    }

    void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

