/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.google.common.collect.Lists;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.core.services.FileTransfer;
import com.netflix.genie.core.util.MetricsUtils;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

public class HttpFileTransferImpl
implements FileTransfer {
    private static final Logger log = LoggerFactory.getLogger(HttpFileTransferImpl.class);
    private final UrlValidator validator = new UrlValidator(new String[]{"http", "https"}, 8L);
    private final RestTemplate restTemplate;
    private final Registry registry;
    private final Id downloadTimerId;
    private final Id uploadTimerId;
    private final Id getLastModifiedTimerId;

    public HttpFileTransferImpl(@NotNull RestTemplate restTemplate, @NotNull Registry registry) {
        this.restTemplate = restTemplate;
        this.registry = registry;
        this.downloadTimerId = registry.createId("genie.files.http.download.timer");
        this.uploadTimerId = registry.createId("genie.files.http.upload.timer");
        this.getLastModifiedTimerId = registry.createId("genie.files.http.getLastModified.timer");
    }

    public boolean isValid(String fileName) throws GenieException {
        log.debug("Called with file name {}", (Object)fileName);
        return this.validator.isValid(fileName);
    }

    public void getFile(@NotBlank(message="Source file path cannot be empty.") String srcRemotePath, @NotBlank(message="Destination local path cannot be empty") String dstLocalPath) throws GenieException {
        long start = System.nanoTime();
        Map tags = MetricsUtils.newSuccessTagsMap();
        log.debug("Called with src path {} and destination path {}", (Object)srcRemotePath, (Object)dstLocalPath);
        try {
            File outputFile = new File(dstLocalPath);
            if (!this.isValid(srcRemotePath)) {
                throw new GenieServerException("Unable to download " + srcRemotePath + " not a valid URL");
            }
            this.restTemplate.execute(srcRemotePath, HttpMethod.GET, requestEntity -> requestEntity.getHeaders().setAccept((List)Lists.newArrayList((Object[])new MediaType[]{MediaType.ALL})), response -> {
                FileUtils.copyInputStreamToFile((InputStream)response.getBody(), (File)outputFile);
                return null;
            }, new Object[0]);
        }
        catch (GenieException | RuntimeException e) {
            MetricsUtils.addFailureTagsWithException((Map)tags, (Throwable)e);
            throw e;
        }
        finally {
            this.registry.timer(this.downloadTimerId.withTags(tags)).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    public void putFile(@NotBlank(message="Source local path cannot be empty.") String srcLocalPath, @NotBlank(message="Destination remote path cannot be empty") String dstRemotePath) throws GenieException {
        long start = System.nanoTime();
        Map tags = MetricsUtils.newSuccessTagsMap();
        try {
            try {
                throw new UnsupportedOperationException("Saving a file to an HttpEndpoint isn't implemented in this version");
            }
            catch (Throwable t) {
                MetricsUtils.addFailureTagsWithException((Map)tags, (Throwable)t);
                throw t;
            }
        }
        catch (Throwable throwable) {
            this.registry.timer(this.uploadTimerId.withTags(tags)).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            throw throwable;
        }
    }

    public long getLastModifiedTime(String path) throws GenieException {
        long lastModtime;
        long start = System.nanoTime();
        Map tags = MetricsUtils.newSuccessTagsMap();
        try {
            URL url = new URL(path);
            long time = this.restTemplate.headForHeaders(url.toURI()).getLastModified();
            lastModtime = time != -1L ? time : Instant.now().toEpochMilli();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            MetricsUtils.addFailureTagsWithException((Map)tags, (Throwable)e);
            throw new GenieServerException("Failed to get metadata for invalid URL", (Throwable)e);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException((Map)tags, (Throwable)t);
            throw t;
        }
        finally {
            this.registry.timer(this.getLastModifiedTimerId.withTags(tags)).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
        return lastModtime;
    }
}

