/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.netflix.genie.core.events.GenieEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.integration.leader.event.OnGrantedEvent;
import org.springframework.integration.leader.event.OnRevokedEvent;

public class LocalLeader {
    private static final Logger log = LoggerFactory.getLogger(LocalLeader.class);
    private final GenieEventBus genieEventBus;
    private final boolean isLeader;

    public LocalLeader(GenieEventBus genieEventBus, boolean isLeader) {
        this.genieEventBus = genieEventBus;
        this.isLeader = isLeader;
        if (this.isLeader) {
            log.info("Constructing LocalLeader. This node IS the leader.");
        } else {
            log.info("Constructing LocalLeader. This node IS NOT the leader.");
        }
    }

    @EventListener
    public void startLeadership(ContextRefreshedEvent event) {
        if (this.isLeader) {
            log.debug("Starting Leadership due to {}", (Object)event);
            this.genieEventBus.publishSynchronousEvent((ApplicationEvent)new OnGrantedEvent((Object)this, null, "leader"));
        }
    }

    @EventListener
    public void stopLeadership(ContextClosedEvent event) {
        if (this.isLeader) {
            log.debug("Stopping Leadership due to {}", (Object)event);
            this.genieEventBus.publishSynchronousEvent((ApplicationEvent)new OnRevokedEvent((Object)this, null, "leader"));
        }
    }
}

