/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.jobs.workflow.WorkflowTask;
import com.netflix.genie.web.properties.DataServiceRetryProperties;
import com.netflix.genie.web.properties.FileCacheProperties;
import com.netflix.genie.web.properties.HealthProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.services.AgentConnectionPersistenceService;
import com.netflix.genie.web.services.AgentJobService;
import com.netflix.genie.web.services.AgentRoutingService;
import com.netflix.genie.web.services.ApplicationPersistenceService;
import com.netflix.genie.web.services.AttachmentService;
import com.netflix.genie.web.services.ClusterLoadBalancer;
import com.netflix.genie.web.services.ClusterPersistenceService;
import com.netflix.genie.web.services.CommandPersistenceService;
import com.netflix.genie.web.services.FileTransferFactory;
import com.netflix.genie.web.services.JobCoordinatorService;
import com.netflix.genie.web.services.JobFileService;
import com.netflix.genie.web.services.JobKillService;
import com.netflix.genie.web.services.JobKillServiceV4;
import com.netflix.genie.web.services.JobPersistenceService;
import com.netflix.genie.web.services.JobSearchService;
import com.netflix.genie.web.services.JobSpecificationService;
import com.netflix.genie.web.services.JobStateService;
import com.netflix.genie.web.services.JobSubmitterService;
import com.netflix.genie.web.services.MailService;
import com.netflix.genie.web.services.impl.AgentJobServiceImpl;
import com.netflix.genie.web.services.impl.AgentRoutingServiceImpl;
import com.netflix.genie.web.services.impl.CacheGenieFileTransferService;
import com.netflix.genie.web.services.impl.DiskJobFileServiceImpl;
import com.netflix.genie.web.services.impl.FileSystemAttachmentService;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.services.impl.JobCoordinatorServiceImpl;
import com.netflix.genie.web.services.impl.JobKillServiceImpl;
import com.netflix.genie.web.services.impl.JobKillServiceV3;
import com.netflix.genie.web.services.impl.JobSpecificationServiceImpl;
import com.netflix.genie.web.services.impl.LocalFileTransferImpl;
import com.netflix.genie.web.services.impl.LocalJobRunner;
import com.netflix.genie.web.tasks.job.JobCompletionService;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.apache.commons.exec.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ServiceLocatorFactoryBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableConfigurationProperties(value={DataServiceRetryProperties.class, FileCacheProperties.class, HealthProperties.class, JobsProperties.class})
public class GenieServicesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={JobKillServiceV3.class})
    public JobKillServiceV3 jobKillServiceV3(GenieHostInfo genieHostInfo, JobSearchService jobSearchService, Executor executor, JobsProperties jobsProperties, GenieEventBus genieEventBus, @Qualifier(value="jobsDir") Resource genieWorkingDir, ObjectMapper objectMapper) {
        return new JobKillServiceV3(genieHostInfo.getHostname(), jobSearchService, executor, jobsProperties.getUsers().isRunAsUserEnabled(), genieEventBus, genieWorkingDir, objectMapper);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobKillService.class})
    public JobKillService jobKillService(JobKillServiceV3 jobKillServiceV3, JobKillServiceV4 jobKillServiceV4, JobPersistenceService jobPersistenceService) {
        return new JobKillServiceImpl(jobKillServiceV3, jobKillServiceV4, jobPersistenceService);
    }

    @Bean
    @ConditionalOnMissingBean(name={"genieFileTransferService"})
    public GenieFileTransferService genieFileTransferService(FileTransferFactory fileTransferFactory) throws GenieException {
        return new GenieFileTransferService(fileTransferFactory);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cacheGenieFileTransferService"})
    public GenieFileTransferService cacheGenieFileTransferService(FileTransferFactory fileTransferFactory, FileCacheProperties fileCacheProperties, LocalFileTransferImpl localFileTransfer, MeterRegistry registry) throws GenieException {
        return new CacheGenieFileTransferService(fileTransferFactory, fileCacheProperties.getLocation(), localFileTransfer, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobSubmitterService.class})
    public JobSubmitterService jobSubmitterService(JobPersistenceService jobPersistenceService, GenieEventBus genieEventBus, List<WorkflowTask> workflowTasks, @Qualifier(value="jobsDir") Resource genieWorkingDir, MeterRegistry registry) {
        return new LocalJobRunner(jobPersistenceService, genieEventBus, workflowTasks, genieWorkingDir, registry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobCoordinatorService.class})
    public JobCoordinatorService jobCoordinatorService(JobPersistenceService jobPersistenceService, JobKillService jobKillService, @Qualifier(value="jobMonitoringCoordinator") JobStateService jobStateService, JobSearchService jobSearchService, JobsProperties jobsProperties, ApplicationPersistenceService applicationPersistenceService, ClusterPersistenceService clusterPersistenceService, CommandPersistenceService commandPersistenceService, JobSpecificationService specificationService, MeterRegistry registry, GenieHostInfo genieHostInfo) {
        return new JobCoordinatorServiceImpl(jobPersistenceService, jobKillService, jobStateService, jobsProperties, applicationPersistenceService, jobSearchService, clusterPersistenceService, commandPersistenceService, specificationService, registry, genieHostInfo.getHostname());
    }

    @Bean
    @ConditionalOnMissingBean(value={AttachmentService.class})
    public AttachmentService attachmentService(JobsProperties jobsProperties) {
        return new FileSystemAttachmentService(jobsProperties.getLocations().getAttachments());
    }

    @Bean
    @ConditionalOnMissingBean(name={"fileTransferFactory"}, value={ServiceLocatorFactoryBean.class})
    public ServiceLocatorFactoryBean fileTransferFactory() {
        ServiceLocatorFactoryBean factoryBean = new ServiceLocatorFactoryBean();
        factoryBean.setServiceLocatorInterface(FileTransferFactory.class);
        return factoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentJobService.class})
    public AgentJobService agentJobService(JobPersistenceService jobPersistenceService, JobSpecificationService jobSpecificationService, MeterRegistry meterRegistry) {
        return new AgentJobServiceImpl(jobPersistenceService, jobSpecificationService, meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobFileService.class})
    public JobFileService jobFileService(@Qualifier(value="jobsDir") Resource jobsDir) throws IOException {
        return new DiskJobFileServiceImpl(jobsDir);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobSpecificationService.class})
    public JobSpecificationService jobSpecificationService(ApplicationPersistenceService applicationPersistenceService, ClusterPersistenceService clusterPersistenceService, CommandPersistenceService commandPersistenceService, @NotEmpty List<ClusterLoadBalancer> clusterLoadBalancers, MeterRegistry registry, JobsProperties jobsProperties) {
        return new JobSpecificationServiceImpl(applicationPersistenceService, clusterPersistenceService, commandPersistenceService, clusterLoadBalancers, registry, jobsProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentRoutingService.class})
    public AgentRoutingService agentRoutingService(AgentConnectionPersistenceService agentConnectionPersistenceService, GenieHostInfo genieHostInfo) {
        return new AgentRoutingServiceImpl(agentConnectionPersistenceService, genieHostInfo);
    }

    @Bean
    @ConditionalOnMissingBean(value={JobCompletionService.class})
    public JobCompletionService jobCompletionService(JobPersistenceService jobPersistenceService, JobSearchService jobSearchService, GenieFileTransferService genieFileTransferService, Resource genieWorkingDir, MailService mailService, MeterRegistry registry, JobsProperties jobsProperties, RetryTemplate retryTemplate) throws GenieException {
        return new JobCompletionService(jobPersistenceService, jobSearchService, genieFileTransferService, genieWorkingDir, mailService, registry, jobsProperties, retryTemplate);
    }
}

