/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.netflix.genie.web.properties.AwsCredentialsProperties;
import com.netflix.genie.web.properties.RetryProperties;
import com.netflix.genie.web.properties.S3FileTransferProperties;
import com.netflix.genie.web.services.impl.S3FileTransferImpl;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@ConditionalOnBean(value={AWSCredentialsProvider.class})
@AutoConfigureAfter(value={ContextCredentialsAutoConfiguration.class})
@EnableConfigurationProperties(value={AwsCredentialsProperties.class, AwsCredentialsProperties.SpringCloudAwsRegionProperties.class, RetryProperties.class, S3FileTransferProperties.class})
public class GenieAwsS3AutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GenieAwsS3AutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"genieAwsClientConfiguration"}, value={ClientConfiguration.class})
    public ClientConfiguration genieAwsClientConfiguration(RetryProperties retryProperties) {
        return new ClientConfiguration().withRetryPolicy(PredefinedRetryPolicies.getDefaultRetryPolicyWithCustomMaxRetries((int)retryProperties.getS3().getNoOfRetries()));
    }

    @Bean
    public AmazonS3 amazonS3(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, AwsCredentialsProperties.SpringCloudAwsRegionProperties springCloudAwsRegionProperties, AwsCredentialsProperties awsCredentialsProperties) {
        AWSCredentialsProvider s3CredentialsProvider;
        String roleArn = awsCredentialsProperties.getRole();
        Regions region = springCloudAwsRegionProperties.getRegion();
        boolean assumeRole = StringUtils.isNotBlank((CharSequence)roleArn);
        if (assumeRole) {
            log.info("AWS configured to assume role {}", (Object)roleArn);
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(credentialsProvider)).withClientConfiguration(clientConfiguration)).withRegion(region)).build();
            String roleSession = "Genie-" + UUID.randomUUID().toString();
            log.info("Role session name for this instance is {}", (Object)roleSession);
            s3CredentialsProvider = new STSAssumeRoleSessionCredentialsProvider.Builder(roleArn, roleSession).withStsClient(stsClient).build();
        } else {
            s3CredentialsProvider = credentialsProvider;
        }
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(s3CredentialsProvider)).withClientConfiguration(clientConfiguration)).withRegion(region)).build();
    }

    @Bean(name={"file.system.s3", "file.system.s3n", "file.system.s3a"})
    @Order(value=1)
    public S3FileTransferImpl s3FileTransferImpl(AmazonS3 amazonS3, MeterRegistry registry, S3FileTransferProperties s3FileTransferProperties) {
        return new S3FileTransferImpl(amazonS3, registry, s3FileTransferProperties);
    }
}

