/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.ClusterCriteria;
import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.internal.dto.v4.AgentConfigRequest;
import com.netflix.genie.common.internal.dto.v4.AgentEnvironmentRequest;
import com.netflix.genie.common.internal.dto.v4.ApplicationMetadata;
import com.netflix.genie.common.internal.dto.v4.ApplicationRequest;
import com.netflix.genie.common.internal.dto.v4.Cluster;
import com.netflix.genie.common.internal.dto.v4.ClusterMetadata;
import com.netflix.genie.common.internal.dto.v4.ClusterRequest;
import com.netflix.genie.common.internal.dto.v4.Command;
import com.netflix.genie.common.internal.dto.v4.CommandMetadata;
import com.netflix.genie.common.internal.dto.v4.CommandRequest;
import com.netflix.genie.common.internal.dto.v4.Criterion;
import com.netflix.genie.common.internal.dto.v4.ExecutionEnvironment;
import com.netflix.genie.common.internal.dto.v4.ExecutionResourceCriteria;
import com.netflix.genie.common.internal.dto.v4.JobArchivalDataRequest;
import com.netflix.genie.common.internal.dto.v4.JobMetadata;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class DtoConverters {
    public static final String GENIE_ID_PREFIX = "genie.id:";
    public static final String GENIE_NAME_PREFIX = "genie.name:";

    private DtoConverters() {
    }

    static ApplicationRequest toV4ApplicationRequest(Application v3Application) {
        ApplicationMetadata.Builder metadataBuilder = (ApplicationMetadata.Builder)new ApplicationMetadata.Builder(v3Application.getName(), v3Application.getUser(), v3Application.getVersion(), v3Application.getStatus()).withTags(DtoConverters.toV4Tags(v3Application.getTags()));
        v3Application.getMetadata().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        v3Application.getType().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withType(arg_0));
        v3Application.getDescription().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withDescription(arg_0));
        ApplicationRequest.Builder builder = new ApplicationRequest.Builder(metadataBuilder.build());
        v3Application.getId().ifPresent(arg_0 -> ((ApplicationRequest.Builder)builder).withRequestedId(arg_0));
        builder.withResources(new ExecutionEnvironment(v3Application.getConfigs(), v3Application.getDependencies(), (String)v3Application.getSetupFile().orElse(null)));
        return builder.build();
    }

    public static com.netflix.genie.common.internal.dto.v4.Application toV4Application(Application v3Application) {
        ApplicationMetadata.Builder metadataBuilder = (ApplicationMetadata.Builder)new ApplicationMetadata.Builder(v3Application.getName(), v3Application.getUser(), v3Application.getVersion(), v3Application.getStatus()).withTags(DtoConverters.toV4Tags(v3Application.getTags()));
        v3Application.getMetadata().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        v3Application.getType().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withType(arg_0));
        v3Application.getDescription().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withDescription(arg_0));
        return new com.netflix.genie.common.internal.dto.v4.Application((String)v3Application.getId().orElseThrow(IllegalArgumentException::new), v3Application.getCreated().orElse(Instant.now()), v3Application.getUpdated().orElse(Instant.now()), new ExecutionEnvironment(v3Application.getConfigs(), v3Application.getDependencies(), (String)v3Application.getSetupFile().orElse(null)), metadataBuilder.build());
    }

    public static Application toV3Application(com.netflix.genie.common.internal.dto.v4.Application v4Application) {
        ApplicationMetadata applicationMetadata = v4Application.getMetadata();
        ExecutionEnvironment resources = v4Application.getResources();
        Application.Builder builder = (Application.Builder)((Application.Builder)((Application.Builder)((Application.Builder)((Application.Builder)((Application.Builder)new Application.Builder(applicationMetadata.getName(), applicationMetadata.getUser(), applicationMetadata.getVersion(), applicationMetadata.getStatus()).withId(v4Application.getId())).withTags(DtoConverters.toV3Tags(v4Application.getId(), applicationMetadata.getName(), applicationMetadata.getTags()))).withConfigs(resources.getConfigs())).withDependencies(resources.getDependencies())).withCreated(v4Application.getCreated())).withUpdated(v4Application.getUpdated());
        applicationMetadata.getType().ifPresent(arg_0 -> ((Application.Builder)builder).withType(arg_0));
        applicationMetadata.getDescription().ifPresent(arg_0 -> ((Application.Builder)builder).withDescription(arg_0));
        applicationMetadata.getMetadata().ifPresent(arg_0 -> ((Application.Builder)builder).withMetadata(arg_0));
        resources.getSetupFile().ifPresent(arg_0 -> ((Application.Builder)builder).withSetupFile(arg_0));
        return builder.build();
    }

    static ClusterRequest toV4ClusterRequest(com.netflix.genie.common.dto.Cluster v3Cluster) {
        ClusterMetadata.Builder metadataBuilder = (ClusterMetadata.Builder)new ClusterMetadata.Builder(v3Cluster.getName(), v3Cluster.getUser(), v3Cluster.getVersion(), v3Cluster.getStatus()).withTags(DtoConverters.toV4Tags(v3Cluster.getTags()));
        v3Cluster.getMetadata().ifPresent(arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        v3Cluster.getDescription().ifPresent(arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withDescription(arg_0));
        ClusterRequest.Builder builder = new ClusterRequest.Builder(metadataBuilder.build());
        v3Cluster.getId().ifPresent(arg_0 -> ((ClusterRequest.Builder)builder).withRequestedId(arg_0));
        builder.withResources(new ExecutionEnvironment(v3Cluster.getConfigs(), v3Cluster.getDependencies(), (String)v3Cluster.getSetupFile().orElse(null)));
        return builder.build();
    }

    public static Cluster toV4Cluster(com.netflix.genie.common.dto.Cluster v3Cluster) {
        ClusterMetadata.Builder metadataBuilder = (ClusterMetadata.Builder)new ClusterMetadata.Builder(v3Cluster.getName(), v3Cluster.getUser(), v3Cluster.getVersion(), v3Cluster.getStatus()).withTags(DtoConverters.toV4Tags(v3Cluster.getTags()));
        v3Cluster.getMetadata().ifPresent(arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        v3Cluster.getDescription().ifPresent(arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withDescription(arg_0));
        return new Cluster((String)v3Cluster.getId().orElseThrow(IllegalArgumentException::new), v3Cluster.getCreated().orElse(Instant.now()), v3Cluster.getUpdated().orElse(Instant.now()), new ExecutionEnvironment(v3Cluster.getConfigs(), v3Cluster.getDependencies(), (String)v3Cluster.getSetupFile().orElse(null)), metadataBuilder.build());
    }

    public static com.netflix.genie.common.dto.Cluster toV3Cluster(Cluster v4Cluster) {
        ClusterMetadata clusterMetadata = v4Cluster.getMetadata();
        ExecutionEnvironment resources = v4Cluster.getResources();
        Cluster.Builder builder = (Cluster.Builder)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)((Cluster.Builder)new Cluster.Builder(clusterMetadata.getName(), clusterMetadata.getUser(), clusterMetadata.getVersion(), clusterMetadata.getStatus()).withId(v4Cluster.getId())).withTags(DtoConverters.toV3Tags(v4Cluster.getId(), clusterMetadata.getName(), clusterMetadata.getTags()))).withConfigs(resources.getConfigs())).withDependencies(resources.getDependencies())).withCreated(v4Cluster.getCreated())).withUpdated(v4Cluster.getUpdated());
        clusterMetadata.getDescription().ifPresent(arg_0 -> ((Cluster.Builder)builder).withDescription(arg_0));
        clusterMetadata.getMetadata().ifPresent(arg_0 -> ((Cluster.Builder)builder).withMetadata(arg_0));
        resources.getSetupFile().ifPresent(arg_0 -> ((Cluster.Builder)builder).withSetupFile(arg_0));
        return builder.build();
    }

    static CommandRequest toV4CommandRequest(com.netflix.genie.common.dto.Command v3Command) {
        CommandMetadata.Builder metadataBuilder = (CommandMetadata.Builder)new CommandMetadata.Builder(v3Command.getName(), v3Command.getUser(), v3Command.getVersion(), v3Command.getStatus()).withTags(DtoConverters.toV4Tags(v3Command.getTags()));
        v3Command.getMetadata().ifPresent(arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        v3Command.getDescription().ifPresent(arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withDescription(arg_0));
        ArrayList executable = Lists.newArrayList((Object[])StringUtils.split((String)v3Command.getExecutable(), (char)' '));
        CommandRequest.Builder builder = new CommandRequest.Builder(metadataBuilder.build(), (List)executable).withCheckDelay(Long.valueOf(v3Command.getCheckDelay()));
        v3Command.getId().ifPresent(arg_0 -> ((CommandRequest.Builder)builder).withRequestedId(arg_0));
        v3Command.getMemory().ifPresent(arg_0 -> ((CommandRequest.Builder)builder).withMemory(arg_0));
        builder.withResources(new ExecutionEnvironment(v3Command.getConfigs(), v3Command.getDependencies(), (String)v3Command.getSetupFile().orElse(null)));
        return builder.build();
    }

    public static Command toV4Command(com.netflix.genie.common.dto.Command v3Command) {
        CommandMetadata.Builder metadataBuilder = (CommandMetadata.Builder)new CommandMetadata.Builder(v3Command.getName(), v3Command.getUser(), v3Command.getVersion(), v3Command.getStatus()).withTags(DtoConverters.toV4Tags(v3Command.getTags()));
        v3Command.getDescription().ifPresent(arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withDescription(arg_0));
        v3Command.getMetadata().ifPresent(arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        ExecutionEnvironment resources = new ExecutionEnvironment(v3Command.getConfigs(), v3Command.getDependencies(), (String)v3Command.getSetupFile().orElse(null));
        return new Command((String)v3Command.getId().orElseThrow(IllegalArgumentException::new), v3Command.getCreated().orElse(Instant.now()), v3Command.getUpdated().orElse(Instant.now()), resources, metadataBuilder.build(), (List)Lists.newArrayList((Object[])StringUtils.split((String)v3Command.getExecutable())), (Integer)v3Command.getMemory().orElse(null), v3Command.getCheckDelay());
    }

    static com.netflix.genie.common.dto.Command toV3Command(Command v4Command) {
        CommandMetadata commandMetadata = v4Command.getMetadata();
        ExecutionEnvironment resources = v4Command.getResources();
        Command.Builder builder = (Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)((Command.Builder)new Command.Builder(commandMetadata.getName(), commandMetadata.getUser(), commandMetadata.getVersion(), commandMetadata.getStatus(), StringUtils.join((Iterable)v4Command.getExecutable(), (char)' '), v4Command.getCheckDelay()).withId(v4Command.getId())).withTags(DtoConverters.toV3Tags(v4Command.getId(), commandMetadata.getName(), commandMetadata.getTags()))).withConfigs(resources.getConfigs())).withDependencies(resources.getDependencies())).withCreated(v4Command.getCreated())).withUpdated(v4Command.getUpdated());
        commandMetadata.getDescription().ifPresent(arg_0 -> ((Command.Builder)builder).withDescription(arg_0));
        commandMetadata.getMetadata().ifPresent(arg_0 -> ((Command.Builder)builder).withMetadata(arg_0));
        resources.getSetupFile().ifPresent(arg_0 -> ((Command.Builder)builder).withSetupFile(arg_0));
        v4Command.getMemory().ifPresent(arg_0 -> ((Command.Builder)builder).withMemory(arg_0));
        return builder.build();
    }

    public static com.netflix.genie.common.internal.dto.v4.JobRequest toV4JobRequest(JobRequest v3JobRequest) throws GeniePreconditionException {
        ExecutionEnvironment resources = new ExecutionEnvironment(v3JobRequest.getConfigs(), v3JobRequest.getDependencies(), (String)v3JobRequest.getSetupFile().orElse(null));
        JobMetadata.Builder metadataBuilder = (JobMetadata.Builder)new JobMetadata.Builder(v3JobRequest.getName(), v3JobRequest.getUser(), v3JobRequest.getVersion()).withTags(v3JobRequest.getTags());
        v3JobRequest.getMetadata().ifPresent(arg_0 -> ((JobMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        v3JobRequest.getEmail().ifPresent(arg_0 -> ((JobMetadata.Builder)metadataBuilder).withEmail(arg_0));
        v3JobRequest.getGroup().ifPresent(arg_0 -> ((JobMetadata.Builder)metadataBuilder).withGroup(arg_0));
        v3JobRequest.getGrouping().ifPresent(arg_0 -> ((JobMetadata.Builder)metadataBuilder).withGrouping(arg_0));
        v3JobRequest.getGroupingInstance().ifPresent(arg_0 -> ((JobMetadata.Builder)metadataBuilder).withGroupingInstance(arg_0));
        v3JobRequest.getDescription().ifPresent(arg_0 -> ((JobMetadata.Builder)metadataBuilder).withDescription(arg_0));
        ArrayList clusterCriteria = Lists.newArrayList();
        for (ClusterCriteria criterion : v3JobRequest.getClusterCriterias()) {
            clusterCriteria.add(DtoConverters.toV4Criterion(criterion));
        }
        ExecutionResourceCriteria criteria = new ExecutionResourceCriteria((List)clusterCriteria, DtoConverters.toV4Criterion(v3JobRequest.getCommandCriteria()), v3JobRequest.getApplications());
        AgentEnvironmentRequest.Builder agentEnvironmentBuilder = new AgentEnvironmentRequest.Builder();
        v3JobRequest.getCpu().ifPresent(arg_0 -> ((AgentEnvironmentRequest.Builder)agentEnvironmentBuilder).withRequestedJobCpu(arg_0));
        v3JobRequest.getMemory().ifPresent(arg_0 -> ((AgentEnvironmentRequest.Builder)agentEnvironmentBuilder).withRequestedJobMemory(arg_0));
        AgentConfigRequest.Builder agentConfigBuilder = new AgentConfigRequest.Builder().withArchivingDisabled(v3JobRequest.isDisableLogArchival()).withInteractive(false);
        v3JobRequest.getTimeout().ifPresent(arg_0 -> ((AgentConfigRequest.Builder)agentConfigBuilder).withTimeoutRequested(arg_0));
        JobArchivalDataRequest.Builder jobArchivalDataRequestBuilder = new JobArchivalDataRequest.Builder();
        return new com.netflix.genie.common.internal.dto.v4.JobRequest((String)v3JobRequest.getId().orElse(null), resources, (List)(v3JobRequest.getCommandArgs().isPresent() ? Lists.newArrayList((Object[])StringUtils.split((String)((String)v3JobRequest.getCommandArgs().get()), (char)' ')) : null), metadataBuilder.build(), criteria, agentEnvironmentBuilder.build(), agentConfigBuilder.build(), jobArchivalDataRequestBuilder.build());
    }

    static JobRequest toV3JobRequest(com.netflix.genie.common.internal.dto.v4.JobRequest v4JobRequest) {
        JobRequest.Builder v3Builder = (JobRequest.Builder)new JobRequest.Builder(v4JobRequest.getMetadata().getName(), v4JobRequest.getMetadata().getUser(), v4JobRequest.getMetadata().getVersion(), v4JobRequest.getCriteria().getClusterCriteria().stream().map(DtoConverters::toClusterCriteria).collect(Collectors.toList()), DtoConverters.toV3CriterionTags(v4JobRequest.getCriteria().getCommandCriterion())).withApplications(v4JobRequest.getCriteria().getApplicationIds()).withCommandArgs(v4JobRequest.getCommandArgs()).withDisableLogArchival(v4JobRequest.getRequestedAgentConfig().isArchivingDisabled()).withTags(v4JobRequest.getMetadata().getTags());
        v4JobRequest.getRequestedId().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withId(arg_0));
        JobMetadata metadata = v4JobRequest.getMetadata();
        metadata.getEmail().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withEmail(arg_0));
        metadata.getGroup().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGroup(arg_0));
        metadata.getGrouping().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGrouping(arg_0));
        metadata.getGroupingInstance().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withGroupingInstance(arg_0));
        metadata.getDescription().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withDescription(arg_0));
        metadata.getMetadata().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withMetadata(arg_0));
        ExecutionEnvironment jobResources = v4JobRequest.getResources();
        v3Builder.withConfigs(jobResources.getConfigs());
        v3Builder.withDependencies(jobResources.getDependencies());
        jobResources.getSetupFile().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withSetupFile(arg_0));
        v4JobRequest.getRequestedAgentConfig().getTimeoutRequested().ifPresent(arg_0 -> ((JobRequest.Builder)v3Builder).withTimeout(arg_0));
        return v3Builder.build();
    }

    public static ImmutableSet<String> toV3Tags(String id, String name, Set<String> tags) {
        ImmutableSet.Builder v3Tags = ImmutableSet.builder();
        v3Tags.addAll(tags);
        v3Tags.add((Object)(GENIE_ID_PREFIX + id));
        v3Tags.add((Object)(GENIE_NAME_PREFIX + name));
        return v3Tags.build();
    }

    private static Set<String> toV4Tags(Set<String> tags) {
        return tags.stream().filter(tag -> !tag.startsWith(GENIE_ID_PREFIX) && !tag.startsWith(GENIE_NAME_PREFIX)).collect(Collectors.toSet());
    }

    static ImmutableSet<String> toV3CriterionTags(Criterion criterion) {
        ImmutableSet.Builder tags = ImmutableSet.builder();
        criterion.getId().ifPresent(id -> tags.add((Object)(GENIE_ID_PREFIX + id)));
        criterion.getName().ifPresent(name -> tags.add((Object)(GENIE_NAME_PREFIX + name)));
        tags.addAll((Iterable)criterion.getTags());
        return tags.build();
    }

    private static ClusterCriteria toClusterCriteria(Criterion criterion) {
        return new ClusterCriteria(DtoConverters.toV3CriterionTags(criterion));
    }

    public static Criterion toV4Criterion(ClusterCriteria criteria) throws GeniePreconditionException {
        return DtoConverters.toV4Criterion(criteria.getTags());
    }

    public static Criterion toV4Criterion(Set<String> tags) throws GeniePreconditionException {
        Criterion.Builder builder = new Criterion.Builder();
        HashSet v4Tags = Sets.newHashSet();
        for (String tag : tags) {
            if (tag.startsWith(GENIE_ID_PREFIX)) {
                builder.withId(tag.substring(GENIE_ID_PREFIX.length()));
                continue;
            }
            if (tag.startsWith(GENIE_NAME_PREFIX)) {
                builder.withName(tag.substring(GENIE_NAME_PREFIX.length()));
                continue;
            }
            v4Tags.add(tag);
        }
        builder.withTags((Set)v4Tags);
        return builder.build();
    }
}

