/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieUserLimitExceededException;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.io.IOException;
import java.util.HashSet;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class GenieExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(GenieExceptionMapper.class);
    static final String CONTROLLER_EXCEPTION_COUNTER_NAME = "genie.web.controllers.exception";
    private static final String NEW_LINE = "\n";
    private static final String USER_NAME_TAG_KEY = "user";
    private static final String LIMIT_TAG_KEY = "limit";
    private final MeterRegistry registry;

    @Autowired
    public GenieExceptionMapper(MeterRegistry registry) {
        this.registry = registry;
    }

    @ExceptionHandler(value={GenieException.class})
    public void handleGenieException(HttpServletResponse response, GenieException e) throws IOException {
        this.countException((Exception)((Object)e));
        log.error(e.getLocalizedMessage(), (Throwable)e);
        response.sendError(e.getErrorCode(), e.getLocalizedMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public void handleConstraintViolation(HttpServletResponse response, ConstraintViolationException cve) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (cve.getConstraintViolations() != null) {
            for (ConstraintViolation cv : cve.getConstraintViolations()) {
                if (builder.length() != 0) {
                    builder.append(NEW_LINE);
                }
                builder.append(cv.getMessage());
            }
        }
        this.countException((Exception)((Object)cve));
        log.error(cve.getLocalizedMessage(), (Throwable)cve);
        response.sendError(HttpStatus.PRECONDITION_FAILED.value(), builder.toString());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public void handleMethodArgumentNotValidException(HttpServletResponse response, MethodArgumentNotValidException e) throws IOException {
        this.countException((Exception)e);
        String errorMessage = e.getMessage();
        log.error(errorMessage, (Throwable)e);
        response.sendError(HttpStatus.PRECONDITION_FAILED.value(), errorMessage);
    }

    private void countException(Exception e) {
        HashSet tags = Sets.newHashSet((Iterable)Tags.of((String)"exceptionClass", (String)e.getClass().getCanonicalName()));
        if (e instanceof GenieUserLimitExceededException) {
            GenieUserLimitExceededException userLimitExceededException = (GenieUserLimitExceededException)e;
            tags.add(Tag.of((String)USER_NAME_TAG_KEY, (String)userLimitExceededException.getUser()));
            tags.add(Tag.of((String)LIMIT_TAG_KEY, (String)userLimitExceededException.getExceededLimitName()));
        }
        this.registry.counter(CONTROLLER_EXCEPTION_COUNTER_NAME, (Iterable)tags).increment();
    }
}

