/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.hateoas.assemblers;

import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.web.controllers.ApplicationRestController;
import com.netflix.genie.web.hateoas.resources.ApplicationResource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class ApplicationResourceAssembler
implements ResourceAssembler<Application, ApplicationResource> {
    public ApplicationResource toResource(Application application) {
        String id = (String)application.getId().orElseThrow(IllegalArgumentException::new);
        ApplicationResource applicationResource = new ApplicationResource(application);
        try {
            applicationResource.add(ControllerLinkBuilder.linkTo((Object)((Object)((ApplicationRestController)ControllerLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getApplication(id))).withSelfRel());
            applicationResource.add(ControllerLinkBuilder.linkTo(((ApplicationRestController)ControllerLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getCommandsForApplication(id, null)).withRel("commands"));
        }
        catch (GenieException ge) {
            throw new RuntimeException(ge);
        }
        return applicationResource;
    }
}

