/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.dto.v4.Command;
import com.netflix.genie.web.jobs.AdminResources;
import com.netflix.genie.web.jobs.FileType;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.impl.GenieBaseTask;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandTask
extends GenieBaseTask {
    private static final Logger log = LoggerFactory.getLogger(CommandTask.class);
    private static final String COMMAND_TASK_TIMER_NAME = "genie.jobs.tasks.commandTask.timer";
    private final GenieFileTransferService fts;

    public CommandTask(@NotNull MeterRegistry registry, @NotNull GenieFileTransferService fts) {
        super(registry);
        this.fts = fts;
    }

    @Override
    public void executeTask(@NotNull Map<String, Object> context) throws GenieException, IOException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            String localPath;
            String commandSetupFile;
            JobExecutionEnvironment jobExecEnv = (JobExecutionEnvironment)context.get("jee");
            Command command = jobExecEnv.getCommand();
            tags.add(Tag.of((String)"commandName", (String)command.getMetadata().getName()));
            tags.add(Tag.of((String)"commandId", (String)command.getId()));
            String jobWorkingDirectory = jobExecEnv.getJobWorkingDir().getCanonicalPath();
            String genieDir = jobWorkingDirectory + "/" + "genie";
            Writer writer = (Writer)context.get("writer");
            log.info("Starting Command Task for job {}", (Object)jobExecEnv.getJobRequest().getId().orElse("<no id>"));
            String commandId = command.getId();
            this.createEntityInstanceDirectory(genieDir, commandId, AdminResources.COMMAND);
            this.createEntityInstanceConfigDirectory(genieDir, commandId, AdminResources.COMMAND);
            this.createEntityInstanceDependenciesDirectory(genieDir, commandId, AdminResources.COMMAND);
            Optional setupFile = command.getResources().getSetupFile();
            if (setupFile.isPresent() && StringUtils.isNotBlank((CharSequence)(commandSetupFile = (String)setupFile.get()))) {
                String localPath2 = super.buildLocalFilePath(jobWorkingDirectory, commandId, commandSetupFile, FileType.SETUP, AdminResources.COMMAND);
                this.fts.getFile(commandSetupFile, localPath2);
                super.generateSetupFileSourceSnippet(commandId, "Command:", localPath2, writer, jobWorkingDirectory);
            }
            for (String configFile : command.getResources().getConfigs()) {
                localPath = super.buildLocalFilePath(jobWorkingDirectory, commandId, configFile, FileType.CONFIG, AdminResources.COMMAND);
                this.fts.getFile(configFile, localPath);
            }
            for (String dependencyFile : command.getResources().getDependencies()) {
                localPath = super.buildLocalFilePath(jobWorkingDirectory, commandId, dependencyFile, FileType.DEPENDENCIES, AdminResources.COMMAND);
                this.fts.getFile(dependencyFile, localPath);
            }
            log.info("Finished Command Task for job {}", (Object)jobExecEnv.getJobRequest().getId().orElse("<no id>"));
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.getRegistry().timer(COMMAND_TASK_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

