/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.jobs.JobConstants;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.impl.GenieBaseTask;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFailureAndKillHandlerLogicTask
extends GenieBaseTask {
    private static final Logger log = LoggerFactory.getLogger(JobFailureAndKillHandlerLogicTask.class);
    private static final String KILL_HANDLER_TIMER_NAME = "genie.jobs.tasks.jobFailureAndKillHandlerLogicTask.timer";

    public JobFailureAndKillHandlerLogicTask(@NotNull MeterRegistry registry) {
        super(registry);
    }

    @Override
    public void executeTask(@NotNull Map<String, Object> context) throws GenieException, IOException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            JobExecutionEnvironment jobExecEnv = (JobExecutionEnvironment)context.get("jee");
            String jobId = jobExecEnv.getJobRequest().getId().orElse("<no id>");
            log.info("Starting Job Failure and Kill Handler Task for job {}", (Object)jobId);
            Writer writer = (Writer)context.get("writer");
            writer.write(JobConstants.JOB_FAILURE_AND_KILL_HANDLER_LOGIC + System.lineSeparator());
            log.info("Finished Job Failure and Kill Handler Task for job {}", (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.getRegistry().timer(KILL_HANDLER_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

