/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.repositories;

import com.netflix.genie.web.jpa.entities.TagEntity;
import com.netflix.genie.web.jpa.repositories.JpaIdRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaTagRepository
extends JpaIdRepository<TagEntity> {
    public static final String SELECT_FOR_UPDATE_UNUSED_TAGS_SQL = "SELECT id FROM tags WHERE id NOT IN (SELECT DISTINCT(tag_id) FROM applications_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM clusters_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM commands_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM criteria_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM jobs_tags) AND created <= :createdThreshold FOR UPDATE;";

    public Optional<TagEntity> findByTag(String var1);

    public boolean existsByTag(String var1);

    public Set<TagEntity> findByTagIn(Set<String> var1);

    @Query(value="SELECT id FROM tags WHERE id NOT IN (SELECT DISTINCT(tag_id) FROM applications_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM clusters_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM commands_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM criteria_tags) AND id NOT IN (SELECT DISTINCT(tag_id) FROM jobs_tags) AND created <= :createdThreshold FOR UPDATE;", nativeQuery=true)
    public Set<Number> findUnusedTags(@Param(value="createdThreshold") Instant var1);

    @Modifying
    public Long deleteByIdIn(Set<Long> var1);
}

