/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.services;

import com.netflix.genie.web.jpa.entities.FileEntity;
import com.netflix.genie.web.jpa.repositories.JpaFileRepository;
import com.netflix.genie.web.jpa.services.JpaFilePersistenceService;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class JpaFilePersistenceServiceImpl
implements JpaFilePersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaFilePersistenceServiceImpl.class);
    private final JpaFileRepository fileRepository;

    public JpaFilePersistenceServiceImpl(JpaFileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    @Override
    public void createFileIfNotExists(@NotBlank(message="File path cannot be blank") @NotBlank(message="File path cannot be blank") String file) {
        if (this.fileRepository.existsByFile(file)) {
            return;
        }
        FileEntity fileEntity = new FileEntity(file);
        try {
            this.fileRepository.saveAndFlush(fileEntity);
        }
        catch (DataIntegrityViolationException e) {
            log.error("File expected not to be there but seems to be {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public long deleteUnusedFiles(@NotNull Instant createdThreshold) {
        return this.fileRepository.deleteByIdIn(this.fileRepository.findUnusedFiles(createdThreshold).stream().map(Number::longValue).collect(Collectors.toSet()));
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<FileEntity> getFile(@NotBlank(message="File path cannot be blank") @NotBlank(message="File path cannot be blank") String file) {
        return this.fileRepository.findByFile(file);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<FileEntity> getFiles(@NotNull Set<String> files) {
        return this.fileRepository.findByFileIn(files);
    }
}

