/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.services;

import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.ClusterCriteria;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.exceptions.GenieConflictException;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.internal.dto.v4.AgentClientMetadata;
import com.netflix.genie.common.internal.dto.v4.AgentConfigRequest;
import com.netflix.genie.common.internal.dto.v4.AgentEnvironmentRequest;
import com.netflix.genie.common.internal.dto.v4.Criterion;
import com.netflix.genie.common.internal.dto.v4.ExecutionEnvironment;
import com.netflix.genie.common.internal.dto.v4.ExecutionResourceCriteria;
import com.netflix.genie.common.internal.dto.v4.JobArchivalDataRequest;
import com.netflix.genie.common.internal.dto.v4.JobMetadata;
import com.netflix.genie.common.internal.dto.v4.JobRequestMetadata;
import com.netflix.genie.common.internal.dto.v4.JobSpecification;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieApplicationNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieCommandNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieIdAlreadyExistsException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieInvalidStatusException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobAlreadyClaimedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.common.util.GenieObjectMapper;
import com.netflix.genie.web.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.jpa.entities.ClusterEntity;
import com.netflix.genie.web.jpa.entities.CommandEntity;
import com.netflix.genie.web.jpa.entities.CriterionEntity;
import com.netflix.genie.web.jpa.entities.FileEntity;
import com.netflix.genie.web.jpa.entities.JobEntity;
import com.netflix.genie.web.jpa.entities.projections.IdProjection;
import com.netflix.genie.web.jpa.entities.projections.v4.IsV4JobProjection;
import com.netflix.genie.web.jpa.entities.projections.v4.JobSpecificationProjection;
import com.netflix.genie.web.jpa.entities.projections.v4.V4JobRequestProjection;
import com.netflix.genie.web.jpa.entities.v4.EntityDtoConverters;
import com.netflix.genie.web.jpa.repositories.JpaApplicationRepository;
import com.netflix.genie.web.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.web.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.web.jpa.repositories.JpaJobRepository;
import com.netflix.genie.web.jpa.services.JpaBaseService;
import com.netflix.genie.web.jpa.services.JpaFilePersistenceService;
import com.netflix.genie.web.jpa.services.JpaServiceUtils;
import com.netflix.genie.web.jpa.services.JpaTagPersistenceService;
import com.netflix.genie.web.services.JobPersistenceService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={GenieException.class, GenieRuntimeException.class, ConstraintViolationException.class})
public class JpaJobPersistenceServiceImpl
extends JpaBaseService
implements JobPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaJobPersistenceServiceImpl.class);
    private final JpaJobRepository jobRepository;

    public JpaJobPersistenceServiceImpl(JpaTagPersistenceService tagPersistenceService, JpaFilePersistenceService filePersistenceService, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository, JpaJobRepository jobRepository) {
        super(tagPersistenceService, filePersistenceService, applicationRepository, clusterRepository, commandRepository);
        this.jobRepository = jobRepository;
    }

    @Override
    public void createJob(@NotNull JobRequest jobRequest, @NotNull com.netflix.genie.common.dto.JobMetadata jobMetadata, @NotNull Job job, @NotNull JobExecution jobExecution) throws GenieException {
        log.debug("Called with\nRequest:\n{}\nMetadata:\n{}\nJob:\n{}\nExecution:\n{}\n", new Object[]{jobRequest, jobMetadata, job, jobExecution});
        String jobId = (String)jobRequest.getId().orElseThrow(() -> new GeniePreconditionException("No job id entered"));
        JobEntity jobEntity = this.toEntity(jobId, jobRequest, jobMetadata, job, jobExecution);
        try {
            this.jobRepository.save(jobEntity);
        }
        catch (DataIntegrityViolationException e) {
            throw new GenieConflictException("A job with id " + jobId + " already exists", (Throwable)e);
        }
    }

    @Override
    public void updateJobWithRuntimeEnvironment(@NotBlank String jobId, @NotBlank String clusterId, @NotBlank String commandId, @NotNull List<String> applicationIds, @Min(value=1L) @Min(value=1L) int memory) throws GenieException {
        log.debug("Called to update job ({}) runtime with cluster {}, command {} and applications {}", new Object[]{jobId, clusterId, commandId, applicationIds});
        JobEntity job = (JobEntity)this.jobRepository.findByUniqueId(jobId).orElseThrow(() -> new GenieNotFoundException("No job with id " + jobId + " exists."));
        try {
            this.setExecutionResources(job, clusterId, commandId, applicationIds);
        }
        catch (GenieApplicationNotFoundException | GenieClusterNotFoundException | GenieCommandNotFoundException e) {
            throw new GenieNotFoundException(e.getMessage(), e);
        }
        job.setMemoryUsed(memory);
        job.setResolved(true);
    }

    @Override
    public void updateJobStatus(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String id, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") JobStatus jobStatus, @NotBlank(message="Status message cannot be empty.") @NotBlank(message="Status message cannot be empty.") String statusMsg) throws GenieException {
        log.debug("Called to update job with id {}, status {} and statusMsg \"{}\"", new Object[]{id, jobStatus, statusMsg});
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No job exists for the id specified"));
        this.updateJobStatus(jobEntity, jobStatus, statusMsg);
    }

    @Override
    public void setJobRunningInformation(@NotBlank String id, @Min(value=0L, message="Must be no lower than zero") @Min(value=0L, message="Must be no lower than zero") int processId, @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") long checkDelay, @NotNull Instant timeout) throws GenieException {
        log.debug("Called with to update job {} with process id {}", (Object)id, (Object)processId);
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists. Unable to update"));
        this.updateJobStatus(jobEntity, JobStatus.RUNNING, "Job is Running.");
        jobEntity.setProcessId(processId);
        jobEntity.setCheckDelay(checkDelay);
        jobEntity.setTimeout(timeout);
    }

    @Override
    public void setJobCompletionInformation(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String id, int exitCode, @NotNull(message="No job status entered. Unable to update") @NotNull(message="No job status entered. Unable to update") JobStatus status, @NotBlank(message="Status message can't be blank. Unable to update") @NotBlank(message="Status message can't be blank. Unable to update") String statusMessage, @Nullable Long stdOutSize, @Nullable Long stdErrSize) throws GenieException {
        log.debug("Called with id: {}, exit code: {}, status: {}, status message: {}, std out size: {}, std err size {}", new Object[]{id, exitCode, status, statusMessage, stdOutSize, stdErrSize});
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists unable to update"));
        this.updateJobStatus(jobEntity, status, statusMessage);
        jobEntity.setExitCode(exitCode);
        jobEntity.setStdOutSize(stdOutSize);
        jobEntity.setStdErrSize(stdErrSize);
    }

    @Override
    public long deleteBatchOfJobsCreatedBeforeDate(@NotNull Instant date, @Min(value=1L) @Min(value=1L) int maxDeleted, @Min(value=1L) @Min(value=1L) int pageSize) {
        Slice<IdProjection> idProjections;
        log.info("Attempting to delete batch of jobs (at most {}) created before {} ms from epoch", (Object)maxDeleted, (Object)date.toEpochMilli());
        long jobsDeleted = 0L;
        long totalAttemptedDeletions = 0L;
        PageRequest page = PageRequest.of((int)0, (int)pageSize);
        do {
            if (!(idProjections = this.jobRepository.findByCreatedBefore(date, (Pageable)page)).hasContent()) continue;
            List<Long> ids = idProjections.getContent().stream().map(IdProjection::getId).collect(Collectors.toList());
            long toBeDeleted = ids.size();
            totalAttemptedDeletions += toBeDeleted;
            log.debug("Attempting to delete {} rows from jobs...", (Object)toBeDeleted);
            long deletedJobs = this.jobRepository.deleteByIdIn(ids);
            log.debug("Successfully deleted {} rows from jobs...", (Object)deletedJobs);
            if (deletedJobs != toBeDeleted) {
                log.error("Deleted {} job records but expected to delete {}", (Object)deletedJobs, (Object)toBeDeleted);
            }
            jobsDeleted += deletedJobs;
        } while (idProjections.hasNext() && totalAttemptedDeletions < (long)maxDeleted);
        log.info("Deleted a chunk of {} job records: {} job", (Object)totalAttemptedDeletions, (Object)jobsDeleted);
        return totalAttemptedDeletions;
    }

    @Override
    public String saveJobRequest(@Valid com.netflix.genie.common.internal.dto.v4.JobRequest jobRequest, @Valid JobRequestMetadata jobRequestMetadata) {
        log.debug("Attempting to save job request {} with request metadata {}", (Object)jobRequest, (Object)jobRequestMetadata);
        JobEntity jobEntity = new JobEntity();
        this.setUniqueId(jobEntity, jobRequest.getRequestedId().orElse(null));
        jobEntity.setCommandArgs(jobRequest.getCommandArgs());
        this.setJobMetadataFields(jobEntity, jobRequest.getMetadata());
        this.setExecutionEnvironmentFields(jobEntity, jobRequest.getResources());
        this.setExecutionResourceCriteriaFields(jobEntity, jobRequest.getCriteria());
        this.setRequestedAgentEnvironmentFields(jobEntity, jobRequest.getRequestedAgentEnvironment());
        this.setRequestedAgentConfigFields(jobEntity, jobRequest.getRequestedAgentConfig());
        this.setRequestedJobArchivalData(jobEntity, jobRequest.getRequestedJobArchivalData());
        this.setRequestMetadataFields(jobEntity, jobRequestMetadata);
        jobEntity.setV4(true);
        try {
            String id = ((JobEntity)this.jobRepository.save(jobEntity)).getUniqueId();
            log.debug("Saved job request {} with request metadata {} under job id {}", new Object[]{jobRequest, jobRequestMetadata, id});
            return id;
        }
        catch (DataIntegrityViolationException e) {
            throw new GenieIdAlreadyExistsException("A job with id " + jobEntity.getUniqueId() + " already exists. Unable to reserve id.", (Throwable)e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<com.netflix.genie.common.internal.dto.v4.JobRequest> getJobRequest(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id) {
        log.debug("Requested to get Job Request for id {}", (Object)id);
        return this.jobRepository.findByUniqueId(id, V4JobRequestProjection.class).map(EntityDtoConverters::toV4JobRequestDto);
    }

    @Override
    public void saveJobSpecification(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id, @Valid JobSpecification specification) {
        log.debug("Requested to save job specification {} for job with id {}", (Object)specification, (Object)id);
        JobEntity entity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> {
            String error = "No job found with id " + id + ". Unable to save job specification";
            log.error(error);
            return new GenieJobNotFoundException(error);
        });
        try {
            if (entity.isResolved()) {
                log.error("Attempted to save job specification {} for job {} that was already resolved", (Object)specification, (Object)id);
                return;
            }
            if (!entity.getStatus().isResolvable()) {
                log.error("Job {} is already in a non-resolvable state {}. Needs to be one of {}. Won't save job spec", new Object[]{id, entity.getStatus(), JobStatus.getResolvableStatuses()});
                return;
            }
            this.setExecutionResources(entity, specification.getCluster().getId(), specification.getCommand().getId(), specification.getApplications().stream().map(JobSpecification.ExecutionResource::getId).collect(Collectors.toList()));
            entity.setEnvironmentVariables(specification.getEnvironmentVariables());
            entity.setJobDirectoryLocation(specification.getJobDirectoryLocation().getAbsolutePath());
            specification.getArchiveLocation().ifPresent(archiveLocation -> entity.setArchiveLocation((String)archiveLocation));
            entity.setResolved(true);
            entity.setStatus(JobStatus.RESOLVED);
            log.debug("Saved job specification {} for job with id {}", (Object)specification, (Object)id);
        }
        catch (GenieApplicationNotFoundException | GenieClusterNotFoundException | GenieCommandNotFoundException e) {
            log.error("Unable to save Job Specification {} for job {} due to {}", new Object[]{specification, id, e.getMessage(), e});
            throw e;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<JobSpecification> getJobSpecification(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id) {
        log.debug("Requested to get job specification for job {}", (Object)id);
        JobSpecificationProjection projection = this.jobRepository.findByUniqueId(id, JobSpecificationProjection.class).orElseThrow(() -> {
            String errorMessage = "No job ith id " + id + "exists. Unable to get job specification.";
            log.error(errorMessage);
            return new GenieJobNotFoundException(errorMessage);
        });
        return projection.isResolved() ? Optional.of(EntityDtoConverters.toJobSpecificationDto(projection)) : Optional.empty();
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isV4(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id) {
        log.debug("Read v4 flag from db for job {} ", (Object)id);
        return this.jobRepository.findByUniqueId(id, IsV4JobProjection.class).orElseThrow(() -> {
            String errorMessage = "No job with id " + id + "exists. Unable to get v4 flag.";
            log.error(errorMessage);
            return new GenieJobNotFoundException(errorMessage);
        }).isV4();
    }

    @Override
    public void claimJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String id, @Valid AgentClientMetadata agentClientMetadata) {
        log.debug("Agent with metadata {} requesting to claim job with id {}", (Object)agentClientMetadata, (Object)id);
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieJobNotFoundException("No job with id " + id + " exists. Unable to claim."));
        if (jobEntity.isClaimed()) {
            throw new GenieJobAlreadyClaimedException("Job with id " + id + " is already claimed. Unable to claim.");
        }
        JobStatus currentStatus = jobEntity.getStatus();
        if (!currentStatus.isClaimable()) {
            throw new GenieInvalidStatusException("Job " + id + " is in status " + currentStatus + " and can't be claimed. Needs to be one of " + JobStatus.getClaimableStatuses());
        }
        jobEntity.setClaimed(true);
        jobEntity.setStatus(JobStatus.CLAIMED);
        agentClientMetadata.getHostname().ifPresent(jobEntity::setAgentHostname);
        agentClientMetadata.getVersion().ifPresent(jobEntity::setAgentVersion);
        agentClientMetadata.getPid().ifPresent(jobEntity::setAgentPid);
        log.debug("Claimed job {} for agent with metadata {}", (Object)id, (Object)agentClientMetadata);
    }

    @Override
    public void updateJobStatus(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String id, @NotNull JobStatus currentStatus, @NotNull JobStatus newStatus, @Nullable String newStatusMessage) {
        log.debug("Requested to change the status of job {} from {} to {} with message {}", new Object[]{id, currentStatus, newStatus, newStatusMessage});
        if (currentStatus == newStatus) {
            throw new GenieInvalidStatusException("Can't update the status of job " + id + " because both current and new status are " + currentStatus);
        }
        JobEntity jobEntity = (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new GenieJobNotFoundException("No job with id " + id + " exists. Unable to update status."));
        JobStatus actualCurrentStatus = jobEntity.getStatus();
        if (actualCurrentStatus != currentStatus) {
            throw new GenieInvalidStatusException("Job " + id + " current status is " + actualCurrentStatus + " but API caller expected it to be " + currentStatus + ". Unable to update status due to inconsistent state.");
        }
        this.updateJobStatus(jobEntity, newStatus, newStatusMessage);
        log.debug("Changed the status of job {} from {} to {} with message {}", new Object[]{id, currentStatus, newStatus, newStatusMessage});
    }

    private void updateJobStatus(JobEntity jobEntity, JobStatus newStatus, @Nullable String statusMsg) {
        JobStatus currentStatus = jobEntity.getStatus();
        if (currentStatus.isActive()) {
            jobEntity.setStatus(newStatus);
            jobEntity.setStatusMsg(statusMsg);
            if (newStatus.equals((Object)JobStatus.RUNNING)) {
                jobEntity.setStarted(Instant.now());
            } else if (jobEntity.getStarted().isPresent() && newStatus.isFinished()) {
                jobEntity.setFinished(Instant.now());
            }
        }
    }

    private JobEntity toEntity(String id, JobRequest jobRequest, com.netflix.genie.common.dto.JobMetadata jobMetadata, Job job, JobExecution jobExecution) {
        FileEntity setupFile;
        JobEntity jobEntity = new JobEntity();
        jobEntity.setUniqueId(id);
        jobEntity.setName(jobRequest.getName());
        jobEntity.setUser(jobRequest.getUser());
        jobEntity.setVersion(jobRequest.getVersion());
        jobEntity.setStatus(JobStatus.INIT);
        jobRequest.getDescription().ifPresent(jobEntity::setDescription);
        jobRequest.getMetadata().ifPresent(metadata -> EntityDtoConverters.setJsonField(metadata, jobEntity::setMetadata));
        JpaServiceUtils.setEntityMetadata(GenieObjectMapper.getMapper(), jobRequest, jobEntity);
        jobRequest.getCommandArgs().ifPresent(commandArgs -> jobEntity.setCommandArgs(Lists.newArrayList((Object[])StringUtils.splitByWholeSeparator((String)commandArgs, (String)" "))));
        jobRequest.getGroup().ifPresent(jobEntity::setGenieUserGroup);
        FileEntity fileEntity = setupFile = jobRequest.getSetupFile().isPresent() ? this.createAndGetFileEntity((String)jobRequest.getSetupFile().get()) : null;
        if (setupFile != null) {
            jobEntity.setSetupFile(setupFile);
        }
        ArrayList clusterCriteria = Lists.newArrayListWithExpectedSize((int)jobRequest.getClusterCriterias().size());
        for (ClusterCriteria clusterCriterion : jobRequest.getClusterCriterias()) {
            clusterCriteria.add(new CriterionEntity(null, null, null, null, this.createAndGetTagEntities(clusterCriterion.getTags())));
        }
        jobEntity.setClusterCriteria(clusterCriteria);
        jobEntity.setCommandCriterion(new CriterionEntity(null, null, null, null, this.createAndGetTagEntities(jobRequest.getCommandCriteria())));
        jobEntity.setConfigs(this.createAndGetFileEntities(jobRequest.getConfigs()));
        jobEntity.setDependencies(this.createAndGetFileEntities(jobRequest.getDependencies()));
        jobEntity.setArchivingDisabled(jobRequest.isDisableLogArchival());
        jobRequest.getEmail().ifPresent(jobEntity::setEmail);
        if (!jobRequest.getTags().isEmpty()) {
            jobEntity.setTags(this.createAndGetTagEntities(jobRequest.getTags()));
        }
        jobRequest.getCpu().ifPresent(jobEntity::setRequestedCpu);
        jobRequest.getMemory().ifPresent(jobEntity::setRequestedMemory);
        if (!jobRequest.getApplications().isEmpty()) {
            jobEntity.setRequestedApplications(jobRequest.getApplications());
        }
        jobRequest.getTimeout().ifPresent(jobEntity::setRequestedTimeout);
        jobRequest.getGrouping().ifPresent(jobEntity::setGrouping);
        jobRequest.getGroupingInstance().ifPresent(jobEntity::setGroupingInstance);
        jobMetadata.getClientHost().ifPresent(jobEntity::setRequestApiClientHostname);
        jobMetadata.getUserAgent().ifPresent(jobEntity::setRequestApiClientUserAgent);
        jobMetadata.getNumAttachments().ifPresent(jobEntity::setNumAttachments);
        jobMetadata.getTotalSizeOfAttachments().ifPresent(jobEntity::setTotalSizeOfAttachments);
        jobMetadata.getStdErrSize().ifPresent(jobEntity::setStdErrSize);
        jobMetadata.getStdOutSize().ifPresent(jobEntity::setStdOutSize);
        job.getArchiveLocation().ifPresent(jobEntity::setArchiveLocation);
        job.getStarted().ifPresent(jobEntity::setStarted);
        job.getFinished().ifPresent(jobEntity::setFinished);
        jobEntity.setStatus(job.getStatus());
        job.getStatusMsg().ifPresent(jobEntity::setStatusMsg);
        jobEntity.setAgentHostname(jobExecution.getHostName());
        jobExecution.getProcessId().ifPresent(jobEntity::setProcessId);
        jobExecution.getCheckDelay().ifPresent(jobEntity::setCheckDelay);
        jobExecution.getTimeout().ifPresent(jobEntity::setTimeout);
        jobExecution.getMemory().ifPresent(jobEntity::setMemoryUsed);
        jobEntity.setV4(false);
        return jobEntity;
    }

    private CriterionEntity toCriterionEntity(Criterion criterion) {
        CriterionEntity criterionEntity = new CriterionEntity();
        criterion.getId().ifPresent(criterionEntity::setUniqueId);
        criterion.getName().ifPresent(criterionEntity::setName);
        criterion.getVersion().ifPresent(criterionEntity::setVersion);
        criterion.getStatus().ifPresent(criterionEntity::setStatus);
        criterionEntity.setTags(this.createAndGetTagEntities(criterion.getTags()));
        return criterionEntity;
    }

    private void setJobMetadataFields(JobEntity jobEntity, JobMetadata jobMetadata) {
        jobEntity.setName(jobMetadata.getName());
        jobEntity.setUser(jobMetadata.getUser());
        jobEntity.setVersion(jobMetadata.getVersion());
        jobEntity.setTags(this.createAndGetTagEntities(jobMetadata.getTags()));
        Optional jsonMetadata = jobMetadata.getMetadata();
        jsonMetadata.ifPresent(jsonNode -> EntityDtoConverters.setJsonField(jsonNode, jobEntity::setMetadata));
        jobMetadata.getDescription().ifPresent(jobEntity::setDescription);
        jobMetadata.getEmail().ifPresent(jobEntity::setEmail);
        jobMetadata.getGroup().ifPresent(jobEntity::setGenieUserGroup);
        jobMetadata.getGrouping().ifPresent(jobEntity::setGrouping);
        jobMetadata.getGroupingInstance().ifPresent(jobEntity::setGroupingInstance);
    }

    private void setExecutionEnvironmentFields(JobEntity jobEntity, ExecutionEnvironment executionEnvironment) {
        FileEntity setupFile;
        FileEntity fileEntity = setupFile = executionEnvironment.getSetupFile().isPresent() ? this.createAndGetFileEntity((String)executionEnvironment.getSetupFile().get()) : null;
        if (setupFile != null) {
            jobEntity.setSetupFile(setupFile);
        }
        jobEntity.setConfigs(this.createAndGetFileEntities(executionEnvironment.getConfigs()));
        jobEntity.setDependencies(this.createAndGetFileEntities(executionEnvironment.getDependencies()));
    }

    private void setExecutionResourceCriteriaFields(JobEntity jobEntity, ExecutionResourceCriteria criteria) {
        List clusterCriteria = criteria.getClusterCriteria();
        ArrayList clusterCriteriaEntities = Lists.newArrayListWithExpectedSize((int)clusterCriteria.size());
        for (Criterion clusterCriterion : clusterCriteria) {
            clusterCriteriaEntities.add(this.toCriterionEntity(clusterCriterion));
        }
        jobEntity.setClusterCriteria(clusterCriteriaEntities);
        jobEntity.setCommandCriterion(this.toCriterionEntity(criteria.getCommandCriterion()));
        jobEntity.setRequestedApplications(criteria.getApplicationIds());
    }

    private void setRequestedAgentEnvironmentFields(JobEntity jobEntity, AgentEnvironmentRequest requestedAgentEnvironment) {
        jobEntity.setRequestedEnvironmentVariables(requestedAgentEnvironment.getRequestedEnvironmentVariables());
        requestedAgentEnvironment.getRequestedJobMemory().ifPresent(jobEntity::setRequestedMemory);
        requestedAgentEnvironment.getRequestedJobCpu().ifPresent(jobEntity::setRequestedCpu);
        Optional agentEnvironmentExt = requestedAgentEnvironment.getExt();
        agentEnvironmentExt.ifPresent(jsonNode -> EntityDtoConverters.setJsonField(jsonNode, jobEntity::setRequestedAgentEnvironmentExt));
    }

    private void setRequestedAgentConfigFields(JobEntity jobEntity, AgentConfigRequest requestedAgentConfig) {
        jobEntity.setInteractive(requestedAgentConfig.isInteractive());
        jobEntity.setArchivingDisabled(requestedAgentConfig.isArchivingDisabled());
        requestedAgentConfig.getRequestedJobDirectoryLocation().ifPresent(location -> jobEntity.setRequestedJobDirectoryLocation(location.getAbsolutePath()));
        requestedAgentConfig.getTimeoutRequested().ifPresent(jobEntity::setRequestedTimeout);
        requestedAgentConfig.getExt().ifPresent(jsonNode -> EntityDtoConverters.setJsonField(jsonNode, jobEntity::setRequestedAgentConfigExt));
    }

    private void setRequestedJobArchivalData(JobEntity jobEntity, JobArchivalDataRequest requestedjobArchivalData) {
        requestedjobArchivalData.getRequestedArchiveLocationPrefix().ifPresent(jobEntity::setRequestedArchiveLocationPrefix);
    }

    private void setRequestMetadataFields(JobEntity jobEntity, JobRequestMetadata jobRequestMetadata) {
        jobEntity.setNumAttachments(jobRequestMetadata.getNumAttachments());
        jobEntity.setTotalSizeOfAttachments(jobRequestMetadata.getTotalSizeOfAttachments());
        jobRequestMetadata.getApiClientMetadata().ifPresent(apiClientMetadata -> {
            apiClientMetadata.getHostname().ifPresent(jobEntity::setRequestApiClientHostname);
            apiClientMetadata.getUserAgent().ifPresent(jobEntity::setRequestApiClientUserAgent);
        });
        jobRequestMetadata.getAgentClientMetadata().ifPresent(agentClientMetadata -> {
            agentClientMetadata.getHostname().ifPresent(jobEntity::setRequestAgentClientHostname);
            agentClientMetadata.getVersion().ifPresent(jobEntity::setRequestAgentClientVersion);
            agentClientMetadata.getPid().ifPresent(jobEntity::setRequestAgentClientPid);
        });
    }

    private void setExecutionResources(JobEntity job, String clusterId, String commandId, List<String> applicationIds) {
        ClusterEntity cluster = this.getClusterEntity(clusterId).orElseThrow(() -> new GenieClusterNotFoundException("Cannot find cluster with ID " + clusterId));
        CommandEntity command = this.getCommandEntity(commandId).orElseThrow(() -> new GenieCommandNotFoundException("Cannot find command with ID " + commandId));
        ArrayList applications = Lists.newArrayList();
        for (String applicationId : applicationIds) {
            ApplicationEntity application = this.getApplicationEntity(applicationId).orElseThrow(() -> new GenieApplicationNotFoundException("Cannot find application with ID + " + applicationId));
            applications.add(application);
        }
        job.setCluster(cluster);
        job.setCommand(command);
        job.setApplications(applications);
    }
}

