/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.validation.constraints.Min;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.users.active-limit")
@Validated
public class JobsUsersActiveLimitProperties {
    public static final String PROPERTY_PREFIX = "genie.jobs.users.active-limit";
    public static final String ENABLED_PROPERTY = "genie.jobs.users.active-limit.enabled";
    public static final boolean DEFAULT_ENABLED = false;
    public static final int DEFAULT_COUNT = 100;
    private boolean enabled = false;
    @Min(value=1L)
    private @Min(value=1L) int count = 100;
    private Map<String, Integer> overrides = Maps.newHashMap();

    public int getUserLimit(String user) {
        return this.overrides.getOrDefault(user, this.count);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getCount() {
        return this.count;
    }

    public Map<String, Integer> getOverrides() {
        return this.overrides;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setOverrides(Map<String, Integer> overrides) {
        this.overrides = overrides;
    }
}

