/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.resources.handlers;

import com.netflix.genie.web.resources.writers.DirectoryWriter;
import com.netflix.genie.web.services.JobFileService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class GenieResourceHttpRequestHandler
extends ResourceHttpRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(GenieResourceHttpRequestHandler.class);
    public static final String GENIE_JOB_IS_ROOT_DIRECTORY = GenieResourceHttpRequestHandler.class.getName() + ".isRootDirectory";
    public static final String GENIE_JOB_ID_ATTRIBUTE = GenieResourceHttpRequestHandler.class.getName() + ".jobId";
    public static final String V4_MOCK_JOB_ID = "V4-Mock-Job-Directory";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final DirectoryWriter directoryWriter;
    private final JobFileService jobFileService;

    public GenieResourceHttpRequestHandler(DirectoryWriter directoryWriter, JobFileService jobFileService) {
        this.directoryWriter = directoryWriter;
        this.jobFileService = jobFileService;
        try {
            this.jobFileService.createJobDirectory(V4_MOCK_JOB_ID);
            this.jobFileService.updateFile(V4_MOCK_JOB_ID, "stdout", 0L, new byte[0]);
            this.jobFileService.updateFile(V4_MOCK_JOB_ID, "stderr", 0L, new byte[0]);
            this.jobFileService.updateFile(V4_MOCK_JOB_ID, "run", 0L, new byte[0]);
        }
        catch (IOException ioe) {
            log.error("Unable to create V4 placeholder job directory. All requests for V4 output will return 404.", (Throwable)ioe);
        }
    }

    public void handleRequest(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ServletException, IOException {
        Resource resource = this.getResource(request);
        if (resource == null || !resource.exists()) {
            response.sendError(HttpStatus.NOT_FOUND.value());
            return;
        }
        File file = resource.getFile();
        if (file.isDirectory()) {
            Object rootDirAttribute = request.getAttribute(GENIE_JOB_IS_ROOT_DIRECTORY);
            boolean isRootDirectory = rootDirAttribute != null ? (Boolean)rootDirAttribute : true;
            String accept = request.getHeader("Accept");
            String requestUrl = request.getHeader("Genie-Forwarded-From") != null ? request.getHeader("Genie-Forwarded-From") : request.getRequestURL().toString();
            try {
                if (accept != null && accept.contains("text/html")) {
                    response.setContentType("text/html");
                    response.getOutputStream().write(this.directoryWriter.toHtml(file, requestUrl, !isRootDirectory).getBytes(UTF_8));
                }
                response.setContentType("application/json");
                response.getOutputStream().write(this.directoryWriter.toJson(file, requestUrl, !isRootDirectory).getBytes(UTF_8));
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            super.handleRequest(request, response);
        }
    }

    protected Resource getResource(HttpServletRequest request) throws IOException {
        String jobId = (String)request.getAttribute(GENIE_JOB_ID_ATTRIBUTE);
        if (StringUtils.isBlank((CharSequence)jobId)) {
            throw new IllegalStateException("Required request attribute '" + GENIE_JOB_ID_ATTRIBUTE + "' is not set");
        }
        String relativePath = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        return this.jobFileService.getJobFileAsResource(jobId, relativePath);
    }

    protected MediaType getMediaType(HttpServletRequest request, @Nonnull Resource resource) {
        MediaType mediaType = super.getMediaType(request, resource);
        return mediaType == null ? MediaType.TEXT_PLAIN : mediaType;
    }
}

