/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services;

import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.dto.v4.AgentClientMetadata;
import com.netflix.genie.common.internal.dto.v4.JobRequestMetadata;
import com.netflix.genie.common.internal.dto.v4.JobSpecification;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
public interface JobPersistenceService {
    public void createJob(@NotNull JobRequest var1, @NotNull JobMetadata var2, @NotNull Job var3, @NotNull JobExecution var4) throws GenieException;

    public void updateJobWithRuntimeEnvironment(@NotBlank String var1, @NotBlank String var2, @NotBlank String var3, @NotNull List<String> var4, @Min(value=1L) @Min(value=1L) int var5) throws GenieException;

    public void updateJobStatus(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String var1, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") JobStatus var2, @NotBlank(message="Status message cannot be empty.") @NotBlank(message="Status message cannot be empty.") String var3) throws GenieException;

    public void setJobRunningInformation(@NotBlank String var1, @Min(value=0L, message="Must be no lower than zero") @Min(value=0L, message="Must be no lower than zero") int var2, @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") @Min(value=1L, message="Must be at least 1 millisecond, preferably much more") long var3, @NotNull Instant var5) throws GenieException;

    public void setJobCompletionInformation(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String var1, int var2, @NotNull(message="No job status entered. Unable to update") @NotNull(message="No job status entered. Unable to update") JobStatus var3, @NotBlank(message="Status message can't be blank. Unable to update") @NotBlank(message="Status message can't be blank. Unable to update") String var4, @Nullable Long var5, @Nullable Long var6) throws GenieException;

    public long deleteBatchOfJobsCreatedBeforeDate(@NotNull Instant var1, @Min(value=1L) @Min(value=1L) int var2, @Min(value=1L) @Min(value=1L) int var3);

    public String saveJobRequest(@Valid com.netflix.genie.common.internal.dto.v4.JobRequest var1, @Valid JobRequestMetadata var2);

    public Optional<com.netflix.genie.common.internal.dto.v4.JobRequest> getJobRequest(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1);

    public void saveJobSpecification(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1, @Valid JobSpecification var2);

    public Optional<JobSpecification> getJobSpecification(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1);

    public void claimJob(@NotBlank(message="Job id is missing and is required") @NotBlank(message="Job id is missing and is required") String var1, @Valid AgentClientMetadata var2);

    public void updateJobStatus(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1, @NotNull JobStatus var2, @NotNull JobStatus var3, @Nullable String var4);

    public boolean isV4(@NotBlank(message="Id is missing and is required") @NotBlank(message="Id is missing and is required") String var1);
}

