/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.internal.dto.v4.AgentClientMetadata;
import com.netflix.genie.common.internal.dto.v4.JobRequest;
import com.netflix.genie.common.internal.dto.v4.JobRequestMetadata;
import com.netflix.genie.common.internal.dto.v4.JobSpecification;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobSpecificationNotFoundException;
import com.netflix.genie.web.services.AgentJobService;
import com.netflix.genie.web.services.JobPersistenceService;
import com.netflix.genie.web.services.JobSpecificationService;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
@Transactional
public class AgentJobServiceImpl
implements AgentJobService {
    private final JobPersistenceService jobPersistenceService;
    private final JobSpecificationService jobSpecificationService;
    private final MeterRegistry meterRegistry;

    public AgentJobServiceImpl(JobPersistenceService jobPersistenceService, JobSpecificationService jobSpecificationService, MeterRegistry meterRegistry) {
        this.jobPersistenceService = jobPersistenceService;
        this.jobSpecificationService = jobSpecificationService;
        this.meterRegistry = meterRegistry;
    }

    @Override
    public String reserveJobId(@Valid JobRequest jobRequest, @Valid AgentClientMetadata agentClientMetadata) {
        JobRequestMetadata jobRequestMetadata = new JobRequestMetadata(null, agentClientMetadata, 0, 0L);
        return this.jobPersistenceService.saveJobRequest(jobRequest, jobRequestMetadata);
    }

    @Override
    public JobSpecification resolveJobSpecification(@NotBlank String id) {
        JobRequest jobRequest = this.jobPersistenceService.getJobRequest(id).orElseThrow(() -> new GenieJobNotFoundException("No job request exists for job id " + id));
        JobSpecification jobSpecification = this.jobSpecificationService.resolveJobSpecification(id, jobRequest);
        this.jobPersistenceService.saveJobSpecification(id, jobSpecification);
        return jobSpecification;
    }

    @Override
    @Transactional(readOnly=true)
    public JobSpecification getJobSpecification(@NotBlank String id) {
        return this.jobPersistenceService.getJobSpecification(id).orElseThrow(() -> new GenieJobSpecificationNotFoundException("No job specification exists for job with id " + id));
    }

    @Override
    @Transactional(readOnly=true)
    public JobSpecification dryRunJobSpecificationResolution(@Valid JobRequest jobRequest) {
        return this.jobSpecificationService.resolveJobSpecification(jobRequest.getRequestedId().orElse(UUID.randomUUID().toString()), jobRequest);
    }

    @Override
    public void claimJob(@NotBlank String id, @Valid AgentClientMetadata agentClientMetadata) {
        this.jobPersistenceService.claimJob(id, agentClientMetadata);
    }

    @Override
    public void updateJobStatus(@NotBlank String id, JobStatus currentStatus, JobStatus newStatus, @Nullable String newStatusMessage) {
        this.jobPersistenceService.updateJobStatus(id, currentStatus, newStatus, newStatusMessage);
    }
}

