/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.web.services.FileTransfer;
import com.netflix.genie.web.services.FileTransferFactory;
import java.net.URI;
import java.net.URISyntaxException;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenieFileTransferService {
    private static final Logger log = LoggerFactory.getLogger(GenieFileTransferService.class);
    private static final String BEAN_NAME_FILE_SYSTEM_PREFIX = "file.system.";
    private final FileTransferFactory fileTransferFactory;

    public GenieFileTransferService(@NotNull FileTransferFactory fileTransferFactory) throws GenieException {
        this.fileTransferFactory = fileTransferFactory;
    }

    public void getFile(@NotBlank(message="Source file path cannot be empty.") @NotBlank(message="Source file path cannot be empty.") String srcRemotePath, @NotBlank(message="Destination local path cannot be empty") @NotBlank(message="Destination local path cannot be empty") String dstLocalPath) throws GenieException {
        log.debug("Called with src path {} and destination path {}", (Object)srcRemotePath, (Object)dstLocalPath);
        this.getFileTransfer(srcRemotePath).getFile(srcRemotePath, dstLocalPath);
    }

    public void putFile(@NotBlank(message="Source local path cannot be empty.") @NotBlank(message="Source local path cannot be empty.") String srcLocalPath, @NotBlank(message="Destination remote path cannot be empty") @NotBlank(message="Destination remote path cannot be empty") String dstRemotePath) throws GenieException {
        log.debug("Called with src path {} and destination path {}", (Object)srcLocalPath, (Object)dstRemotePath);
        this.getFileTransfer(dstRemotePath).putFile(srcLocalPath, dstRemotePath);
    }

    FileTransfer getFileTransfer(String path) throws GenieNotFoundException {
        FileTransfer result;
        try {
            URI uri = new URI(path);
            result = this.fileTransferFactory.get(BEAN_NAME_FILE_SYSTEM_PREFIX + uri.getScheme());
        }
        catch (URISyntaxException ignored) {
            throw new GenieNotFoundException("Invalid file path: " + path, (Throwable)ignored);
        }
        if (result == null) {
            throw new GenieNotFoundException("Failed getting the appropriate FileTransfer implementation to get file: " + path);
        }
        return result;
    }
}

