/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import java.util.Date;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;

@ThreadSafe
public class ExponentialBackOffTrigger
implements Trigger {
    private static final float POSITIVE_NUMBER = 1.0f;
    private final DelayType delayType;
    private final long minDelay;
    private final long maxDelay;
    private final float factor;
    private long currentDelay;

    public ExponentialBackOffTrigger(DelayType delayType, long minDelay, long maxDelay, float factor) {
        this.delayType = delayType;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        this.factor = factor;
        if (Math.signum(minDelay) != 1.0f) {
            throw new IllegalArgumentException("Minimum delay must be a positive number");
        }
        if (maxDelay < minDelay) {
            throw new IllegalArgumentException("Maximum delay must be larger than minimum");
        }
        if (Math.signum(factor) != 1.0f) {
            throw new IllegalArgumentException("Factor must be a positive number");
        }
        this.reset();
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        Date baseTimeOffset = null;
        switch (this.delayType) {
            case FROM_PREVIOUS_SCHEDULING: {
                baseTimeOffset = triggerContext.lastScheduledExecutionTime();
                break;
            }
            case FROM_PREVIOUS_EXECUTION_BEGIN: {
                baseTimeOffset = triggerContext.lastActualExecutionTime();
                break;
            }
            case FROM_PREVIOUS_EXECUTION_COMPLETION: {
                baseTimeOffset = triggerContext.lastCompletionTime();
                break;
            }
            default: {
                throw new RuntimeException("Unhandled delay type: " + (Object)((Object)this.delayType));
            }
        }
        if (baseTimeOffset == null) {
            baseTimeOffset = new Date();
        }
        return new Date(baseTimeOffset.toInstant().toEpochMilli() + this.getAndIncrementDelay());
    }

    public synchronized void reset() {
        this.currentDelay = this.minDelay;
    }

    private synchronized long getAndIncrementDelay() {
        long delay = this.currentDelay;
        this.currentDelay = Math.min(this.maxDelay, (long)(this.factor * (float)this.currentDelay));
        return delay;
    }

    public static enum DelayType {
        FROM_PREVIOUS_SCHEDULING,
        FROM_PREVIOUS_EXECUTION_BEGIN,
        FROM_PREVIOUS_EXECUTION_COMPLETION;

    }
}

