/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ClientFactory {
    private static final Logger log = LoggerFactory.getLogger(S3ClientFactory.class);
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final ClientConfiguration awsClientConfiguration;
    private final String awsRegion;
    private final boolean assumeRole;
    private final String roleArn;
    private final AmazonS3 defaultS3Client;

    public S3ClientFactory(@NotNull AWSCredentialsProvider awsCredentialsProvider, @NotNull ClientConfiguration awsClientConfiguration, @NotNull String awsRegion, @Nullable String roleArn) {
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.awsClientConfiguration = awsClientConfiguration;
        this.awsRegion = awsRegion;
        this.roleArn = roleArn;
        this.assumeRole = StringUtils.isNotBlank((CharSequence)this.roleArn);
        this.defaultS3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(awsClientConfiguration)).withRegion(this.awsRegion)).build();
    }

    public AmazonS3 getS3Client() {
        if (this.assumeRole) {
            AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withCredentials(this.awsCredentialsProvider)).withClientConfiguration(this.awsClientConfiguration)).withRegion(this.awsRegion)).build();
            AssumeRoleRequest roleRequest = new AssumeRoleRequest().withRoleArn(this.roleArn).withRoleSessionName("Genie-" + UUID.randomUUID().toString());
            AssumeRoleResult roleResult = stsClient.assumeRole(roleRequest);
            Credentials sessionCredentials = roleResult.getCredentials();
            BasicSessionCredentials basicSessionCredentials = new BasicSessionCredentials(sessionCredentials.getAccessKeyId(), sessionCredentials.getSecretAccessKey(), sessionCredentials.getSessionToken());
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)basicSessionCredentials))).withClientConfiguration(this.awsClientConfiguration)).withRegion(this.awsRegion)).build();
        }
        return this.defaultS3Client;
    }
}

