/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

import com.netflix.genie.common.exceptions.GenieTimeoutException;
import com.netflix.genie.web.util.ProcessChecker;
import java.io.IOException;
import java.time.Instant;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.SystemUtils;

public class UnixProcessChecker
implements ProcessChecker {
    private final Executor executor;
    private final CommandLine commandLine;
    private final Instant timeout;

    public UnixProcessChecker(@Min(value=1L) @Min(value=1L) int pid, @NotNull Executor executor, @NotNull Instant timeout) {
        if (!SystemUtils.IS_OS_UNIX) {
            throw new IllegalArgumentException("Not running on a Unix system.");
        }
        this.executor = executor;
        this.commandLine = new CommandLine("ps");
        this.commandLine.addArgument("-p");
        this.commandLine.addArgument(Integer.toString(pid));
        this.timeout = timeout;
    }

    @Override
    public void checkProcess() throws GenieTimeoutException, ExecuteException, IOException {
        this.executor.execute(this.commandLine);
        if (Instant.now().isAfter(this.timeout)) {
            throw new GenieTimeoutException("Job has exceeded its timeout time of " + this.timeout);
        }
    }
}

