/*
 *
 *  Copyright 2016 Netflix, Inc.
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 */
package com.netflix.genie.web.events;

import lombok.Getter;

import javax.validation.constraints.NotBlank;

/**
 * An event fired from within the Genie system when it needs a specific job killed.
 *
 * @author tgianos
 * @since 3.0.0
 */
@Getter
public class KillJobEvent extends BaseJobEvent {

    private final String reason;

    /**
     * Constructor.
     *
     * @param id     The id of the job to kill
     * @param reason The reason this job is being requested to be killed
     * @param source The source object which threw this event
     */
    public KillJobEvent(@NotBlank final String id, @NotBlank final String reason, final Object source) {
        super(id, source);
        this.reason = reason;
    }
}
