/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.jobs.workflow.WorkflowTask;
import com.netflix.genie.web.jobs.workflow.impl.ApplicationTask;
import com.netflix.genie.web.jobs.workflow.impl.ClusterTask;
import com.netflix.genie.web.jobs.workflow.impl.CommandTask;
import com.netflix.genie.web.jobs.workflow.impl.InitialSetupTask;
import com.netflix.genie.web.jobs.workflow.impl.JobFailureAndKillHandlerLogicTask;
import com.netflix.genie.web.jobs.workflow.impl.JobKickoffTask;
import com.netflix.genie.web.jobs.workflow.impl.JobTask;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.services.AttachmentService;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.services.impl.HttpFileTransferImpl;
import com.netflix.genie.web.services.impl.LocalFileTransferImpl;
import io.micrometer.core.instrument.MeterRegistry;
import org.apache.commons.exec.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;

@Configuration
public class GenieJobWorkflowAutoConfiguration {
    @Bean(name={"file.system.file", "file.system.null"})
    @Order(value=2)
    public LocalFileTransferImpl localFileTransfer() {
        return new LocalFileTransferImpl();
    }

    @Bean(name={"file.system.http", "file.system.https"})
    @Order(value=3)
    public HttpFileTransferImpl httpFileTransfer(RestTemplate restTemplate, MeterRegistry registry) {
        return new HttpFileTransferImpl(restTemplate, registry);
    }

    @Bean
    @Order(value=0)
    public WorkflowTask jobKillLogicTask(MeterRegistry registry) {
        return new JobFailureAndKillHandlerLogicTask(registry);
    }

    @Bean
    @Order(value=1)
    public WorkflowTask initialSetupTask(MeterRegistry registry) {
        return new InitialSetupTask(registry);
    }

    @Bean
    @Order(value=2)
    public WorkflowTask clusterProcessorTask(MeterRegistry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new ClusterTask(registry, fts);
    }

    @Bean
    @Order(value=3)
    public WorkflowTask applicationProcessorTask(MeterRegistry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new ApplicationTask(registry, fts);
    }

    @Bean
    @Order(value=4)
    public WorkflowTask commandProcessorTask(MeterRegistry registry, @Qualifier(value="cacheGenieFileTransferService") GenieFileTransferService fts) {
        return new CommandTask(registry, fts);
    }

    @Bean
    @Order(value=5)
    public WorkflowTask jobProcessorTask(AttachmentService attachmentService, MeterRegistry registry, @Qualifier(value="genieFileTransferService") GenieFileTransferService fts) {
        return new JobTask(attachmentService, registry, fts);
    }

    @Bean
    @Order(value=6)
    public WorkflowTask jobKickoffTask(JobsProperties jobsProperties, Executor executor, GenieHostInfo genieHostInfo, MeterRegistry registry) {
        return new JobKickoffTask(jobsProperties.getUsers().isRunAsUserEnabled(), jobsProperties.getUsers().isCreationEnabled(), executor, genieHostInfo.getHostname(), registry);
    }
}

