/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.health;

import com.netflix.genie.web.properties.JobsMemoryProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.services.JobMetricsService;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class GenieMemoryHealthIndicator
implements HealthIndicator {
    private static final String NUMBER_RUNNING_JOBS_KEY = "numRunningJobs";
    private static final String USED_MEMORY_KEY = "usedMemory";
    private static final String AVAILABLE_MEMORY = "availableMemory";
    private static final String AVAILABLE_DEFAULT_JOB_CAPACITY = "availableDefaultJobCapacity";
    private static final String AVAILABLE_MAX_JOB_CAPACITY = "availableMaxJobCapacity";
    private final JobMetricsService jobMetricsService;
    private final JobsProperties jobsProperties;

    @Autowired
    public GenieMemoryHealthIndicator(@NotNull JobMetricsService jobMetricsService, @NotNull JobsProperties jobsProperties) {
        this.jobMetricsService = jobMetricsService;
        this.jobsProperties = jobsProperties;
    }

    public Health health() {
        int usedMemory = this.jobMetricsService.getUsedMemory();
        JobsMemoryProperties memoryProperties = this.jobsProperties.getMemory();
        int availableMemory = memoryProperties.getMaxSystemMemory() - usedMemory;
        int maxJobMemory = memoryProperties.getMaxJobMemory();
        int defaultJobMemory = memoryProperties.getDefaultJobMemory();
        Health.Builder builder = availableMemory >= maxJobMemory ? Health.up() : Health.outOfService();
        return builder.withDetail(NUMBER_RUNNING_JOBS_KEY, (Object)this.jobMetricsService.getNumActiveJobs()).withDetail(USED_MEMORY_KEY, (Object)usedMemory).withDetail(AVAILABLE_MEMORY, (Object)availableMemory).withDetail(AVAILABLE_DEFAULT_JOB_CAPACITY, (Object)(availableMemory >= 0 && defaultJobMemory > 0 ? availableMemory / defaultJobMemory : 0)).withDetail(AVAILABLE_MAX_JOB_CAPACITY, (Object)(availableMemory >= 0 && maxJobMemory > 0 ? availableMemory / maxJobMemory : 0)).build();
    }
}

