/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.forwarding")
@Validated
public class JobsForwardingProperties {
    public static final String PROPERTY_PREFIX = "genie.jobs.forwarding";
    public static final String ENABLED_PROPERTY = "genie.jobs.forwarding.enabled";
    private boolean enabled;
    @NotEmpty(message="A scheme is required for forwarding")
    private @NotEmpty(message="A scheme is required for forwarding") String scheme = "http";
    @Min(value=1L, message="Port can't be less than one for forwarding")
    private @Min(value=1L, message="Port can't be less than one for forwarding") int port = 8080;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

