/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.impl;

import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.services.AttachmentService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemAttachmentService
implements AttachmentService {
    private static final Logger log = LoggerFactory.getLogger(FileSystemAttachmentService.class);
    private File attachmentDirectory;

    public FileSystemAttachmentService(String attachmentsDirectory) {
        this.createAttachmentDirectory(attachmentsDirectory);
    }

    @Override
    public void save(String jobId, String filename, InputStream content) throws GenieException {
        File attachment = new File(this.attachmentDirectory, jobId + "/" + filename);
        try {
            FileUtils.copyInputStreamToFile((InputStream)content, (File)attachment);
            log.info("Saved {} to {}", (Object)filename, (Object)attachment.getAbsolutePath());
        }
        catch (IOException ioe) {
            throw new GenieServerException("Failed to save attachment", (Throwable)ioe);
        }
    }

    @Override
    public void copy(String jobId, File destination) throws GenieException {
        if (destination.exists() && !destination.isDirectory()) {
            throw new GeniePreconditionException(destination + " is not a directory and it needs to be.");
        }
        File source = new File(this.attachmentDirectory, jobId);
        if (source.exists() && source.isDirectory()) {
            try {
                FileUtils.copyDirectory((File)source, (File)destination);
            }
            catch (IOException ioe) {
                throw new GenieServerException("Failed to copy attachment directory", (Throwable)ioe);
            }
        }
    }

    @Override
    public void delete(String jobId) throws GenieException {
        File jobDir = new File(this.attachmentDirectory, jobId);
        if (jobDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)jobDir);
            }
            catch (IOException ioe) {
                throw new GenieServerException("Failed to delete directory " + jobId, (Throwable)ioe);
            }
        }
    }

    private void createAttachmentDirectory(String attachmentsDirectory) {
        String attachmentsDirectoryPath = attachmentsDirectory;
        if (!attachmentsDirectoryPath.endsWith(File.separator)) {
            attachmentsDirectoryPath = attachmentsDirectory + File.separator;
        }
        try {
            File dir = new File(new URI(attachmentsDirectoryPath));
            if (!dir.exists()) {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            this.attachmentDirectory = dir;
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("Failed to create attachments directory " + attachmentsDirectoryPath, e);
        }
    }
}

