/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.services.loadbalancers.script;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.dto.v4.Cluster;
import com.netflix.genie.web.controllers.DtoConverters;
import com.netflix.genie.web.services.ClusterLoadBalancer;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.validation.constraints.NotEmpty;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.TaskScheduler;

public class ScriptLoadBalancer
implements ClusterLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(ScriptLoadBalancer.class);
    static final String SELECT_TIMER_NAME = "genie.jobs.clusters.loadBalancers.script.select.timer";
    static final String UPDATE_TIMER_NAME = "genie.jobs.clusters.loadBalancers.script.update.timer";
    static final String STATUS_TAG_OK = "ok";
    static final String STATUS_TAG_NOT_FOUND = "not found";
    static final String STATUS_TAG_NOT_CONFIGURED = "not configured";
    static final String STATUS_TAG_FOUND = "found";
    static final String STATUS_TAG_FAILED = "failed";
    private static final long DEFAULT_TIMEOUT_LENGTH = 5000L;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String SLASH = "/";
    private static final String PERIOD = ".";
    private static final String CLUSTERS_BINDING = "clusters";
    private static final String JOB_REQUEST_BINDING = "jobRequest";
    private final AtomicBoolean isUpdating = new AtomicBoolean();
    private final AtomicBoolean isConfigured = new AtomicBoolean();
    private final ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private final AsyncTaskExecutor asyncTaskExecutor;
    private final GenieFileTransferService fileTransferService;
    private final Environment environment;
    private final ObjectMapper mapper;
    private final MeterRegistry registry;
    private final AtomicReference<CompiledScript> script = new AtomicReference<Object>(null);
    private final AtomicLong timeoutLength = new AtomicLong(5000L);

    public ScriptLoadBalancer(AsyncTaskExecutor asyncTaskExecutor, TaskScheduler taskScheduler, GenieFileTransferService fileTransferService, Environment environment, ObjectMapper mapper, MeterRegistry registry) {
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.fileTransferService = fileTransferService;
        this.environment = environment;
        this.mapper = mapper;
        this.registry = registry;
        long refreshRate = (Long)this.environment.getProperty("genie.jobs.clusters.load-balancers.script.refreshRate", Long.class, (Object)300000L);
        taskScheduler.scheduleWithFixedDelay(this::refresh, refreshRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cluster selectCluster(@Nonnull @NotEmpty @NonNull Set<Cluster> clusters, @Nonnull @NonNull JobRequest jobRequest) throws GenieException {
        if (clusters == null) {
            throw new NullPointerException("clusters is marked @NonNull but is null");
        }
        if (jobRequest == null) {
            throw new NullPointerException("jobRequest is marked @NonNull but is null");
        }
        long selectStart = System.nanoTime();
        log.debug("Called");
        HashSet tags = Sets.newHashSet();
        try {
            String clusterId;
            SimpleBindings bindings2;
            if (this.isConfigured.get() && this.script.get() != null) {
                log.debug("Evaluating script for job {}", (Object)jobRequest.getId().orElse("without id"));
                bindings2 = new SimpleBindings();
                bindings2.put(CLUSTERS_BINDING, (Object)this.mapper.writeValueAsString(clusters.stream().map(DtoConverters::toV3Cluster).collect(Collectors.toSet())));
                bindings2.put(JOB_REQUEST_BINDING, (Object)this.mapper.writeValueAsString((Object)jobRequest));
                clusterId = (String)this.asyncTaskExecutor.submit(() -> (String)this.script.get().eval(bindings2)).get(this.timeoutLength.get(), TimeUnit.MILLISECONDS);
                if (clusterId != null) {
                    for (Cluster cluster : clusters) {
                        if (!clusterId.equals(cluster.getId())) continue;
                        tags.add(Tag.of((String)"status", (String)STATUS_TAG_FOUND));
                        Cluster cluster2 = cluster;
                        return cluster2;
                    }
                }
            } else {
                log.debug("Script returned null");
                tags.add(Tag.of((String)"status", (String)STATUS_TAG_NOT_CONFIGURED));
                Cluster bindings2 = null;
                return bindings2;
            }
            log.warn("Script returned a cluster not in the input list: {}", (Object)clusterId);
            tags.add(Tag.of((String)"status", (String)STATUS_TAG_NOT_FOUND));
            bindings2 = null;
            return bindings2;
        }
        catch (Exception e) {
            tags.add(Tag.of((String)"status", (String)STATUS_TAG_FAILED));
            tags.add(Tag.of((String)"exceptionClass", (String)e.getClass().getCanonicalName()));
            log.error("Unable to execute script due to {}", (Object)e.getMessage(), (Object)e);
            Cluster cluster = null;
            return cluster;
        }
        finally {
            this.registry.timer(SELECT_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - selectStart, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        log.debug("Refreshing");
        long updateStart = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            this.isUpdating.set(true);
            this.timeoutLength.set((Long)this.environment.getProperty("genie.jobs.clusters.load-balancers.script.timeout", Long.class, (Object)5000L));
            String scriptFileSourceValue = this.environment.getProperty("genie.jobs.clusters.load-balancers.script.source");
            if (StringUtils.isBlank((CharSequence)scriptFileSourceValue)) {
                throw new IllegalStateException("Invalid empty value for script source file property: genie.jobs.clusters.load-balancers.script.source");
            }
            String scriptFileSource = new URI(scriptFileSourceValue).toString();
            String scriptFileDestinationValue = this.environment.getProperty("genie.jobs.clusters.load-balancers.script.destination");
            if (StringUtils.isBlank((CharSequence)scriptFileDestinationValue)) {
                throw new IllegalStateException("Invalid empty value for script destination directory property: genie.jobs.clusters.load-balancers.script.destination");
            }
            Path scriptDestinationDirectory = Paths.get(new URI(scriptFileDestinationValue));
            if (!Files.exists(scriptDestinationDirectory, new LinkOption[0])) {
                Files.createDirectories(scriptDestinationDirectory, new FileAttribute[0]);
            } else if (!Files.isDirectory(scriptDestinationDirectory, new LinkOption[0])) {
                throw new IllegalStateException("The script destination directory " + scriptDestinationDirectory + " exists but is not a directory");
            }
            String fileName = StringUtils.substringAfterLast((String)scriptFileSource, (String)SLASH);
            if (StringUtils.isBlank((CharSequence)fileName)) {
                throw new IllegalStateException("No file name found from " + scriptFileSource);
            }
            String scriptExtension = StringUtils.substringAfterLast((String)fileName, (String)PERIOD);
            if (StringUtils.isBlank((CharSequence)scriptExtension)) {
                throw new IllegalStateException("No file extension available in " + fileName);
            }
            Path scriptDestinationPath = scriptDestinationDirectory.resolve(fileName);
            this.fileTransferService.getFile(scriptFileSource, scriptDestinationPath.toUri().toString());
            ScriptEngine engine = this.scriptEngineManager.getEngineByExtension(scriptExtension);
            if (!(engine instanceof Compilable)) {
                throw new IllegalArgumentException("Script engine must be of type " + Compilable.class.getName());
            }
            Compilable compilable = (Compilable)((Object)engine);
            try (InputStream fis = Files.newInputStream(scriptDestinationPath, new OpenOption[0]);
                 InputStreamReader reader = new InputStreamReader(fis, UTF_8);){
                log.debug("Compiling {}", (Object)scriptFileSource);
                this.script.set(compilable.compile(reader));
            }
            tags.add(Tag.of((String)"status", (String)STATUS_TAG_OK));
            this.isConfigured.set(true);
        }
        catch (GenieException | IOException | RuntimeException | URISyntaxException | ScriptException e) {
            tags.add(Tag.of((String)"status", (String)STATUS_TAG_FAILED));
            tags.add(Tag.of((String)"exceptionClass", (String)e.getClass().getName()));
            log.error("Refreshing the load balancing script for ScriptLoadBalancer failed due to {}", (Object)e.getMessage(), (Object)e);
            this.isConfigured.set(false);
        }
        finally {
            this.isUpdating.set(false);
            this.registry.timer(UPDATE_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - updateStart, TimeUnit.NANOSECONDS);
            log.debug("Refresh completed");
        }
    }
}

