/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.job;

import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.exceptions.GenieTimeoutException;
import com.netflix.genie.common.internal.util.ExponentialBackOffTrigger;
import com.netflix.genie.web.events.GenieEventBus;
import com.netflix.genie.web.events.JobFinishedEvent;
import com.netflix.genie.web.events.JobFinishedReason;
import com.netflix.genie.web.events.KillJobEvent;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.node.NodeTask;
import com.netflix.genie.web.util.ProcessChecker;
import com.netflix.genie.web.util.UnixProcessChecker;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.NonNull;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.Executor;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;

public class JobMonitor
extends NodeTask {
    private static final Logger log = LoggerFactory.getLogger(JobMonitor.class);
    private static final int MAX_ERRORS = 5;
    private final String id;
    private final JobExecution execution;
    private final ProcessChecker processChecker;
    private final GenieEventBus genieEventBus;
    private final File stdOut;
    private final File stdErr;
    private final long maxStdOutLength;
    private final long maxStdErrLength;
    private final Trigger trigger;
    private final Counter successfulCheckRate;
    private final Counter timeoutRate;
    private final Counter finishedRate;
    private final Counter unsuccessfulCheckRate;
    private final Counter stdOutTooLarge;
    private final Counter stdErrTooLarge;
    private int errorCount;

    JobMonitor(@Valid JobExecution execution, @NotNull File stdOut, @NotNull File stdErr, @NotNull Executor executor, @NonNull GenieEventBus genieEventBus, @NotNull MeterRegistry registry, @NotNull JobsProperties jobsProperties) {
        if (genieEventBus == null) {
            throw new NullPointerException("genieEventBus is marked @NonNull but is null");
        }
        if (!SystemUtils.IS_OS_UNIX) {
            throw new UnsupportedOperationException("Genie doesn't currently support " + SystemUtils.OS_NAME);
        }
        this.errorCount = 0;
        this.id = (String)execution.getId().orElseThrow(IllegalArgumentException::new);
        this.execution = execution;
        this.genieEventBus = genieEventBus;
        int processId = (Integer)execution.getProcessId().orElseThrow(IllegalArgumentException::new);
        Instant timeout = (Instant)execution.getTimeout().orElseThrow(IllegalArgumentException::new);
        this.processChecker = new UnixProcessChecker(processId, executor, timeout);
        this.stdOut = stdOut;
        this.stdErr = stdErr;
        this.maxStdOutLength = jobsProperties.getMax().getStdOutSize();
        this.maxStdErrLength = jobsProperties.getMax().getStdErrSize();
        this.trigger = new ExponentialBackOffTrigger(ExponentialBackOffTrigger.DelayType.FROM_PREVIOUS_SCHEDULING, jobsProperties.getCompletionCheckBackOff().getMinInterval(), execution.getCheckDelay().orElse(jobsProperties.getCompletionCheckBackOff().getMaxInterval()).longValue(), jobsProperties.getCompletionCheckBackOff().getFactor());
        this.successfulCheckRate = registry.counter("genie.jobs.successfulStatusCheck.rate", new String[0]);
        this.timeoutRate = registry.counter("genie.jobs.timeout.rate", new String[0]);
        this.finishedRate = registry.counter("genie.jobs.finished.rate", new String[0]);
        this.unsuccessfulCheckRate = registry.counter("genie.jobs.unsuccessfulStatusCheck.rate", new String[0]);
        this.stdOutTooLarge = registry.counter("genie.jobs.stdOutTooLarge.rate", new String[0]);
        this.stdErrTooLarge = registry.counter("genie.jobs.stdErrTooLarge.rate", new String[0]);
    }

    @Override
    public void run() {
        block7: {
            try {
                this.processChecker.checkProcess();
                log.debug("Job {} is still running...", (Object)this.id);
                if (this.errorCount != 0) {
                    this.errorCount = 0;
                }
                if (this.stdOut.exists() && this.stdOut.length() > this.maxStdOutLength) {
                    this.genieEventBus.publishSynchronousEvent(new KillJobEvent(this.id, "Std out length exceeded.", this));
                    this.stdOutTooLarge.increment();
                    return;
                }
                if (this.stdErr.exists() && this.stdErr.length() > this.maxStdErrLength) {
                    this.genieEventBus.publishSynchronousEvent(new KillJobEvent(this.id, "Std err length exceeded.", this));
                    this.stdErrTooLarge.increment();
                    return;
                }
                this.successfulCheckRate.increment();
            }
            catch (GenieTimeoutException gte) {
                log.info("Job {} has timed out", (Object)this.execution.getId(), (Object)gte);
                this.timeoutRate.increment();
                this.genieEventBus.publishSynchronousEvent(new KillJobEvent(this.id, "Job exceeded timeout.", this));
            }
            catch (ExecuteException ee) {
                log.info("Job {} has finished", (Object)this.id);
                this.finishedRate.increment();
                this.genieEventBus.publishAsynchronousEvent(new JobFinishedEvent(this.id, JobFinishedReason.PROCESS_COMPLETED, "Process detected to be complete", this));
            }
            catch (IOException ioe) {
                log.error("Some IOException happened unable to check process status for pid {}", (Object)this.execution.getProcessId(), (Object)ioe);
                ++this.errorCount;
                this.unsuccessfulCheckRate.increment();
                if (this.errorCount <= 5) break block7;
                this.genieEventBus.publishSynchronousEvent(new KillJobEvent(this.id, "Couldn't check job process status.", this));
                this.genieEventBus.publishAsynchronousEvent(new JobFinishedEvent(this.id, JobFinishedReason.KILLED, "Couldn't check job process status.", this));
            }
        }
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.TRIGGER;
    }

    @Override
    public Trigger getTrigger() {
        return this.trigger;
    }
}

