/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.properties.AgentCleanupProperties;
import com.netflix.genie.web.properties.ClusterCheckerProperties;
import com.netflix.genie.web.properties.DatabaseCleanupProperties;
import com.netflix.genie.web.properties.DiskCleanupProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.properties.TasksExecutorPoolProperties;
import com.netflix.genie.web.properties.TasksSchedulerPoolProperties;
import com.netflix.genie.web.properties.UserMetricsProperties;
import com.netflix.genie.web.services.ClusterPersistenceService;
import com.netflix.genie.web.services.FilePersistenceService;
import com.netflix.genie.web.services.JobPersistenceService;
import com.netflix.genie.web.services.JobSearchService;
import com.netflix.genie.web.services.TagPersistenceService;
import com.netflix.genie.web.tasks.leader.AgentJobCleanupTask;
import com.netflix.genie.web.tasks.leader.ClusterCheckerTask;
import com.netflix.genie.web.tasks.leader.DatabaseCleanupTask;
import com.netflix.genie.web.tasks.leader.UserMetricsTask;
import com.netflix.genie.web.tasks.node.DiskCleanupTask;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableScheduling
@EnableConfigurationProperties(value={ClusterCheckerProperties.class, DatabaseCleanupProperties.class, DiskCleanupProperties.class, TasksExecutorPoolProperties.class, TasksSchedulerPoolProperties.class, UserMetricsProperties.class, AgentCleanupProperties.class})
public class GenieTasksAutoConfiguration {
    private static final int SINGLE_THREAD = 1;

    @Bean
    @ConditionalOnMissingBean(value={Executor.class})
    public Executor processExecutor() {
        DefaultExecutor executor = new DefaultExecutor();
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler(null, null));
        return executor;
    }

    @Bean
    @ConditionalOnMissingBean(name={"genieTaskScheduler"})
    public ThreadPoolTaskScheduler genieTaskScheduler(TasksSchedulerPoolProperties tasksSchedulerPoolProperties) {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(tasksSchedulerPoolProperties.getSize());
        scheduler.setThreadNamePrefix(tasksSchedulerPoolProperties.getThreadNamePrefix());
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"heartBeatServiceTaskScheduler"})
    public TaskScheduler heartBeatServiceTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(1);
        return scheduler;
    }

    @Bean
    @ConditionalOnMissingBean(name={"genieAsyncTaskExecutor"})
    public AsyncTaskExecutor genieAsyncTaskExecutor(TasksExecutorPoolProperties tasksExecutorPoolProperties) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(tasksExecutorPoolProperties.getSize());
        executor.setThreadNamePrefix(tasksExecutorPoolProperties.getThreadNamePrefix());
        return executor;
    }

    @Bean
    @ConditionalOnMissingBean(name={"genieSyncTaskExecutor"})
    public SyncTaskExecutor genieSyncTaskExecutor() {
        return new SyncTaskExecutor();
    }

    @Bean
    @ConditionalOnMissingBean(value={ClusterCheckerTask.class})
    public ClusterCheckerTask clusterCheckerTask(GenieHostInfo genieHostInfo, ClusterCheckerProperties properties, JobSearchService jobSearchService, JobPersistenceService jobPersistenceService, @Qualifier(value="genieRestTemplate") RestTemplate restTemplate, WebEndpointProperties webEndpointProperties, MeterRegistry registry) {
        return new ClusterCheckerTask(genieHostInfo, properties, jobSearchService, jobPersistenceService, restTemplate, webEndpointProperties, registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.database-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={DatabaseCleanupTask.class})
    public DatabaseCleanupTask databaseCleanupTask(DatabaseCleanupProperties cleanupProperties, JobPersistenceService jobPersistenceService, ClusterPersistenceService clusterPersistenceService, FilePersistenceService filePersistenceService, TagPersistenceService tagPersistenceService, MeterRegistry registry) {
        return new DatabaseCleanupTask(cleanupProperties, jobPersistenceService, clusterPersistenceService, filePersistenceService, tagPersistenceService, registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.disk-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={DiskCleanupTask.class})
    public DiskCleanupTask diskCleanupTask(DiskCleanupProperties properties, @Qualifier(value="genieTaskScheduler") TaskScheduler scheduler, Resource jobsDir, JobSearchService jobSearchService, JobsProperties jobsProperties, Executor processExecutor, MeterRegistry registry) throws IOException {
        return new DiskCleanupTask(properties, scheduler, jobsDir, jobSearchService, jobsProperties, processExecutor, registry);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.user-metrics.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={UserMetricsTask.class})
    public UserMetricsTask userMetricsTask(MeterRegistry registry, JobSearchService jobSearchService, UserMetricsProperties userMetricsProperties) {
        return new UserMetricsTask(registry, jobSearchService, userMetricsProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"genie.tasks.agent-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={AgentJobCleanupTask.class})
    public AgentJobCleanupTask agentJobCleanupTask(JobSearchService jobSearchService, JobPersistenceService jobPersistenceService, AgentCleanupProperties agentCleanupProperties) {
        return new AgentJobCleanupTask(jobSearchService, jobPersistenceService, agentCleanupProperties);
    }
}

