/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.controllers;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.ApplicationStatus;
import com.netflix.genie.common.dto.CommandStatus;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.util.GenieObjectMapper;
import com.netflix.genie.web.controllers.DtoConverters;
import com.netflix.genie.web.hateoas.assemblers.ApplicationResourceAssembler;
import com.netflix.genie.web.hateoas.assemblers.CommandResourceAssembler;
import com.netflix.genie.web.hateoas.resources.ApplicationResource;
import com.netflix.genie.web.hateoas.resources.CommandResource;
import com.netflix.genie.web.services.ApplicationPersistenceService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/applications"})
public class ApplicationRestController {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRestController.class);
    private final ApplicationPersistenceService applicationPersistenceService;
    private final ApplicationResourceAssembler applicationResourceAssembler;
    private final CommandResourceAssembler commandResourceAssembler;

    @Autowired
    public ApplicationRestController(ApplicationPersistenceService applicationPersistenceService, ApplicationResourceAssembler applicationResourceAssembler, CommandResourceAssembler commandResourceAssembler) {
        this.applicationPersistenceService = applicationPersistenceService;
        this.applicationResourceAssembler = applicationResourceAssembler;
        this.commandResourceAssembler = commandResourceAssembler;
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createApplication(@RequestBody Application app) throws GenieException {
        log.info("Called to create new application: {}", (Object)app);
        String id = this.applicationPersistenceService.createApplication(DtoConverters.toV4ApplicationRequest(app));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{id}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllApplications() throws GenieException {
        log.warn("Called to delete all Applications");
        this.applicationPersistenceService.deleteAllApplications();
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<ApplicationResource> getApplications(@RequestParam(value="name", required=false) @Nullable String name, @RequestParam(value="user", required=false) @Nullable String user, @RequestParam(value="status", required=false) @Nullable Set<String> statuses, @RequestParam(value="tag", required=false) @Nullable Set<String> tags, @RequestParam(value="type", required=false) @Nullable String type, @PageableDefault(sort={"updated"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<Application> assembler) throws GenieException {
        Page applications;
        log.info("Finding applications [name | user | status | tags | type | pageable]\n{} | {} | {} | {} | | {} | {}", new Object[]{name, user, statuses, tags, type, page});
        EnumSet<ApplicationStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(ApplicationStatus.class);
            for (String status : statuses) {
                enumStatuses.add(ApplicationStatus.parse((String)status));
            }
        }
        if (tags != null && tags.stream().filter(tag -> tag.startsWith("genie.id:")).count() >= 1L) {
            ArrayList applicationList = Lists.newArrayList();
            int prefixLength = "genie.id:".length();
            tags.stream().filter(tag -> tag.startsWith("genie.id:")).forEach(tag -> {
                String id = tag.substring(prefixLength);
                try {
                    applicationList.add(DtoConverters.toV3Application(this.applicationPersistenceService.getApplication(id)));
                }
                catch (GenieException ge) {
                    log.debug("No application with id {} found", (Object)id, (Object)ge);
                }
            });
            applications = new PageImpl((List)applicationList);
        } else if (tags != null && tags.stream().filter(tag -> tag.startsWith("genie.name:")).count() >= 1L) {
            Set<String> finalTags = tags.stream().filter(tag -> !tag.startsWith("genie.name:")).collect(Collectors.toSet());
            if (name == null) {
                Optional<String> finalName = tags.stream().filter(tag -> tag.startsWith("genie.name:")).map(tag -> tag.substring("genie.name:".length())).findFirst();
                applications = this.applicationPersistenceService.getApplications(finalName.orElse(null), user, enumStatuses, finalTags, type, page).map(DtoConverters::toV3Application);
            } else {
                applications = this.applicationPersistenceService.getApplications(name, user, enumStatuses, finalTags, type, page).map(DtoConverters::toV3Application);
            }
        } else {
            applications = this.applicationPersistenceService.getApplications(name, user, enumStatuses, tags, type, page).map(DtoConverters::toV3Application);
        }
        Link self = ControllerLinkBuilder.linkTo(((ApplicationRestController)ControllerLinkBuilder.methodOn(ApplicationRestController.class, (Object[])new Object[0])).getApplications(name, user, statuses, tags, type, page, assembler)).withSelfRel();
        return assembler.toResource(applications, (ResourceAssembler)this.applicationResourceAssembler, self);
    }

    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public ApplicationResource getApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called to get Application for id {}", (Object)id);
        return this.applicationResourceAssembler.toResource(DtoConverters.toV3Application(this.applicationPersistenceService.getApplication(id)));
    }

    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateApplication(@PathVariable(value="id") String id, @RequestBody Application updateApp) throws GenieException {
        log.info("called to update application {} with info {}", (Object)id, (Object)updateApp);
        this.applicationPersistenceService.updateApplication(id, DtoConverters.toV4Application(updateApp));
    }

    @PatchMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchApplication(@PathVariable(value="id") String id, @RequestBody JsonPatch patch) throws GenieException {
        log.info("Called to patch application {} with patch {}", (Object)id, (Object)patch);
        Application currentApp = DtoConverters.toV3Application(this.applicationPersistenceService.getApplication(id));
        try {
            log.debug("Will patch application {}. Original state: {}", (Object)id, (Object)currentApp);
            JsonNode applicationNode = GenieObjectMapper.getMapper().valueToTree((Object)currentApp);
            JsonNode postPatchNode = patch.apply(applicationNode);
            Application patchedApp = (Application)GenieObjectMapper.getMapper().treeToValue((TreeNode)postPatchNode, Application.class);
            log.debug("Finished patching application {}. New state: {}", (Object)id, (Object)patchedApp);
            this.applicationPersistenceService.updateApplication(id, DtoConverters.toV4Application(patchedApp));
        }
        catch (JsonPatchException | IOException e) {
            log.error("Unable to patch application {} with patch {} due to exception.", new Object[]{id, patch, e});
            throw new GenieServerException(e.getLocalizedMessage(), e);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Delete an application with id {}", (Object)id);
        this.applicationPersistenceService.deleteApplication(id);
    }

    @PostMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addConfigsToApplication(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.info("Called with id {} and config {}", (Object)id, configs);
        this.applicationPersistenceService.addConfigsToApplication(id, configs);
    }

    @GetMapping(value={"/{id}/configs"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getConfigsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return this.applicationPersistenceService.getConfigsForApplication(id);
    }

    @PutMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfigsForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws GenieException {
        log.info("Called with id {} and configs {}", (Object)id, configs);
        this.applicationPersistenceService.updateConfigsForApplication(id, configs);
    }

    @DeleteMapping(value={"/{id}/configs"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllConfigsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.applicationPersistenceService.removeAllConfigsForApplication(id);
    }

    @PostMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addDependenciesForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.info("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.applicationPersistenceService.addDependenciesForApplication(id, dependencies);
    }

    @GetMapping(value={"/{id}/dependencies"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getDependenciesForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return this.applicationPersistenceService.getDependenciesForApplication(id);
    }

    @PutMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDependenciesForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws GenieException {
        log.info("Called with id {} and dependencies {}", (Object)id, dependencies);
        this.applicationPersistenceService.updateDependenciesForApplication(id, dependencies);
    }

    @DeleteMapping(value={"/{id}/dependencies"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllDependenciesForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.applicationPersistenceService.removeAllDependenciesForApplication(id);
    }

    @PostMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addTagsForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.info("Called with id {} and config {}", (Object)id, tags);
        this.applicationPersistenceService.addTagsForApplication(id, tags);
    }

    @GetMapping(value={"/{id}/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getTagsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        return DtoConverters.toV3Application(this.applicationPersistenceService.getApplication(id)).getTags();
    }

    @PutMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTagsForApplication(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws GenieException {
        log.info("Called with id {} and tags {}", (Object)id, tags);
        this.applicationPersistenceService.updateTagsForApplication(id, tags);
    }

    @DeleteMapping(value={"/{id}/tags"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllTagsForApplication(@PathVariable(value="id") String id) throws GenieException {
        log.info("Called with id {}", (Object)id);
        this.applicationPersistenceService.removeAllTagsForApplication(id);
    }

    @DeleteMapping(value={"/{id}/tags/{tag}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeTagForApplication(@PathVariable(value="id") String id, @PathVariable(value="tag") String tag) throws GenieException {
        log.info("Called with id {} and tag {}", (Object)id, (Object)tag);
        this.applicationPersistenceService.removeTagForApplication(id, tag);
    }

    @GetMapping(value={"/{id}/commands"}, produces={"application/hal+json"})
    public Set<CommandResource> getCommandsForApplication(@PathVariable(value="id") String id, @RequestParam(value="status", required=false) @Nullable Set<String> statuses) throws GenieException {
        log.info("Called with id {} and statuses {}", (Object)id, statuses);
        EnumSet<CommandStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(CommandStatus.class);
            for (String status : statuses) {
                enumStatuses.add(CommandStatus.parse((String)status));
            }
        }
        return this.applicationPersistenceService.getCommandsForApplication(id, enumStatuses).stream().map(DtoConverters::toV3Command).map(this.commandResourceAssembler::toResource).collect(Collectors.toSet());
    }
}

