/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.health;

import com.netflix.genie.web.services.AgentMetricsService;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class GenieAgentHealthIndicator
implements HealthIndicator {
    static final String NUM_CONNECTED_AGENTS = "numConnectedAgents";
    private final AgentMetricsService agentMetricsService;

    public GenieAgentHealthIndicator(AgentMetricsService agentMetricsService) {
        this.agentMetricsService = agentMetricsService;
    }

    public Health health() {
        Health.Builder builder = new Health.Builder();
        builder.up();
        builder.withDetail(NUM_CONNECTED_AGENTS, (Object)this.agentMetricsService.getNumConnectedAgents());
        return builder.build();
    }
}

