/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jobs.workflow.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GeniePreconditionException;
import com.netflix.genie.web.jobs.JobExecutionEnvironment;
import com.netflix.genie.web.jobs.workflow.impl.GenieBaseTask;
import com.netflix.genie.web.services.AttachmentService;
import com.netflix.genie.web.services.impl.GenieFileTransferService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTask
extends GenieBaseTask {
    private static final Logger log = LoggerFactory.getLogger(JobTask.class);
    private static final String JOB_TASK_TIMER_NAME = "genie.jobs.tasks.jobTask.timer";
    private static final String EMPTY_STRING = "";
    private final AttachmentService attachmentService;
    private final GenieFileTransferService fts;

    public JobTask(@NotNull AttachmentService attachmentService, @NotNull MeterRegistry registry, @NotNull GenieFileTransferService fts) {
        super(registry);
        this.attachmentService = attachmentService;
        this.fts = fts;
    }

    @Override
    public void executeTask(@NotNull Map<String, Object> context) throws GenieException, IOException {
        long start = System.nanoTime();
        HashSet tags = Sets.newHashSet();
        try {
            String jobSetupFile;
            JobExecutionEnvironment jobExecEnv = (JobExecutionEnvironment)context.get("jee");
            String jobWorkingDirectory = jobExecEnv.getJobWorkingDir().getCanonicalPath();
            Writer writer = (Writer)context.get("writer");
            String jobId = (String)jobExecEnv.getJobRequest().getId().orElseThrow(() -> new GeniePreconditionException("No job id found. Unable to continue"));
            log.info("Starting Job Task for job {}", (Object)jobId);
            Optional setupFile = jobExecEnv.getJobRequest().getSetupFile();
            if (setupFile.isPresent() && StringUtils.isNotBlank((CharSequence)(jobSetupFile = (String)setupFile.get()))) {
                String localPath = jobWorkingDirectory + "/" + jobSetupFile.substring(jobSetupFile.lastIndexOf("/") + 1);
                this.fts.getFile(jobSetupFile, localPath);
                writer.write("# Sourcing setup file specified in job request" + System.lineSeparator());
                writer.write("source " + localPath.replace(jobWorkingDirectory, "${GENIE_JOB_DIR}") + System.lineSeparator());
                writer.write(System.lineSeparator());
            }
            HashSet configsAndDependencies = Sets.newHashSet();
            configsAndDependencies.addAll(jobExecEnv.getJobRequest().getDependencies());
            configsAndDependencies.addAll(jobExecEnv.getJobRequest().getConfigs());
            for (String dependentFile : configsAndDependencies) {
                if (!StringUtils.isNotBlank((CharSequence)dependentFile)) continue;
                String localPath = jobWorkingDirectory + "/" + dependentFile.substring(dependentFile.lastIndexOf("/") + 1);
                this.fts.getFile(dependentFile, localPath);
            }
            this.attachmentService.copy(jobId, jobExecEnv.getJobWorkingDir());
            this.attachmentService.delete(jobId);
            writer.write("# Dump the environment to a env.log file" + System.lineSeparator());
            writer.write("env | sort > ${GENIE_JOB_DIR}/genie/logs/env.log" + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("# Kick off the command in background mode and wait for it using its pid" + System.lineSeparator());
            writer.write(StringUtils.join((Iterable)jobExecEnv.getCommand().getExecutable(), (char)' ') + " " + jobExecEnv.getJobRequest().getCommandArgs().orElse(EMPTY_STRING) + " > " + "${" + "GENIE_JOB_DIR" + "}/" + "stdout" + " 2> " + "${" + "GENIE_JOB_DIR" + "}/" + "stderr" + " &" + System.lineSeparator());
            writer.write("export CHILDREN_PID=$!" + System.lineSeparator());
            writer.write("wait ${CHILDREN_PID}" + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("# Write the return code from the command in the done file." + System.lineSeparator());
            writer.write("printf '{\"exitCode\": \"%s\"}\\n' \"$?\" > ${GENIE_JOB_DIR}/genie/genie.done.temp" + System.lineSeparator());
            writer.write("# Swapping done file, unless one exist created by trap handler." + System.lineSeparator());
            writer.write("mv -n ${GENIE_JOB_DIR}/genie/genie.done.temp ${GENIE_JOB_DIR}/genie/genie.done" + System.lineSeparator());
            writer.write("echo End: `date '+%Y-%m-%d %H:%M:%S'`\n");
            log.info("Finished Job Task for job {}", (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            this.getRegistry().timer(JOB_TASK_TIMER_NAME, (Iterable)tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}

