/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.services;

import com.google.common.collect.Sets;
import com.netflix.genie.common.internal.dto.v4.ExecutionEnvironment;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.jpa.entities.ClusterEntity;
import com.netflix.genie.web.jpa.entities.CommandEntity;
import com.netflix.genie.web.jpa.entities.FileEntity;
import com.netflix.genie.web.jpa.entities.TagEntity;
import com.netflix.genie.web.jpa.entities.UniqueIdEntity;
import com.netflix.genie.web.jpa.repositories.JpaApplicationRepository;
import com.netflix.genie.web.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.web.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.web.jpa.services.JpaFilePersistenceService;
import com.netflix.genie.web.jpa.services.JpaTagPersistenceService;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JpaBaseService {
    private static final Logger log = LoggerFactory.getLogger(JpaBaseService.class);
    private final JpaTagPersistenceService tagPersistenceService;
    private final JpaFilePersistenceService filePersistenceService;
    private final JpaApplicationRepository applicationRepository;
    private final JpaClusterRepository clusterRepository;
    private final JpaCommandRepository commandRepository;

    JpaBaseService(JpaTagPersistenceService tagPersistenceService, JpaFilePersistenceService filePersistenceService, JpaApplicationRepository applicationRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository) {
        this.tagPersistenceService = tagPersistenceService;
        this.filePersistenceService = filePersistenceService;
        this.applicationRepository = applicationRepository;
        this.clusterRepository = clusterRepository;
        this.commandRepository = commandRepository;
    }

    FileEntity createAndGetFileEntity(@NotBlank(message="File path cannot be blank") @NotBlank(message="File path cannot be blank") String file) {
        this.filePersistenceService.createFileIfNotExists(file);
        return this.filePersistenceService.getFile(file).orElseThrow(() -> new GenieRuntimeException("Couldn't find file entity for file " + file));
    }

    Set<FileEntity> createAndGetFileEntities(Set<String> files) {
        HashSet fileEntities = Sets.newHashSet();
        for (String file : files) {
            fileEntities.add(this.createAndGetFileEntity(file));
        }
        return fileEntities;
    }

    TagEntity createAndGetTagEntity(@NotBlank(message="Tag cannot be blank") @NotBlank(message="Tag cannot be blank") String tag) {
        this.tagPersistenceService.createTagIfNotExists(tag);
        return this.tagPersistenceService.getTag(tag).orElseThrow(() -> new GenieRuntimeException("Couldn't find tag entity for tag " + tag));
    }

    Set<TagEntity> createAndGetTagEntities(Set<String> tags) {
        HashSet tagEntities = Sets.newHashSet();
        for (String tag : tags) {
            tagEntities.add(this.createAndGetTagEntity(tag));
        }
        return tagEntities;
    }

    <E extends UniqueIdEntity> void setUniqueId(E entity, @Nullable String requestedId) {
        if (requestedId != null) {
            entity.setUniqueId(requestedId);
            entity.setRequestedId(true);
        } else {
            entity.setUniqueId(UUID.randomUUID().toString());
            entity.setRequestedId(false);
        }
    }

    void setEntityResources(ExecutionEnvironment resources, Consumer<Set<FileEntity>> configsConsumer, Consumer<Set<FileEntity>> dependenciesConsumer, Consumer<FileEntity> setupFileConsumer) {
        configsConsumer.accept(this.createAndGetFileEntities(resources.getConfigs()));
        dependenciesConsumer.accept(this.createAndGetFileEntities(resources.getDependencies()));
        setupFileConsumer.accept(resources.getSetupFile().isPresent() ? this.createAndGetFileEntity((String)resources.getSetupFile().get()) : null);
    }

    void setEntityTags(Set<String> tags, Consumer<Set<TagEntity>> tagsConsumer) {
        tagsConsumer.accept(this.createAndGetTagEntities(tags));
    }

    Optional<ApplicationEntity> getApplicationEntity(@NotBlank(message="No application id entered") @NotBlank(message="No application id entered") String id) {
        return this.applicationRepository.findByUniqueId(id);
    }

    Optional<ClusterEntity> getClusterEntity(@NotBlank(message="No cluster id entered") @NotBlank(message="No cluster id entered") String id) {
        return this.clusterRepository.findByUniqueId(id);
    }

    Optional<CommandEntity> getCommandEntity(@NotBlank(message="No command id entered") @NotBlank(message="No command id entered") String id) {
        return this.commandRepository.findByUniqueId(id);
    }

    JpaTagPersistenceService getTagPersistenceService() {
        return this.tagPersistenceService;
    }

    JpaFilePersistenceService getFilePersistenceService() {
        return this.filePersistenceService;
    }

    JpaApplicationRepository getApplicationRepository() {
        return this.applicationRepository;
    }

    JpaClusterRepository getClusterRepository() {
        return this.clusterRepository;
    }

    JpaCommandRepository getCommandRepository() {
        return this.commandRepository;
    }
}

