/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.web.properties.UserMetricsProperties;
import com.netflix.genie.web.services.JobSearchService;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.leader.LeadershipTask;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMetricsTask
extends LeadershipTask {
    private static final Logger log = LoggerFactory.getLogger(UserMetricsTask.class);
    private static final String USER_ACTIVE_JOBS_METRIC_NAME = "genie.user.active-jobs.gauge";
    private static final String USER_ACTIVE_MEMORY_METRIC_NAME = "genie.user.active-memory.gauge";
    private static final String USER_ACTIVE_USERS_METRIC_NAME = "genie.user.active-users.gauge";
    private final MeterRegistry registry;
    private final JobSearchService jobSearchService;
    private final UserMetricsProperties userMetricsProperties;
    private final Set<String> usersToReset = Sets.newHashSet();

    public UserMetricsTask(MeterRegistry registry, JobSearchService jobSearchService, UserMetricsProperties userMetricsProperties) {
        this.registry = registry;
        this.jobSearchService = jobSearchService;
        this.userMetricsProperties = userMetricsProperties;
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.FIXED_RATE;
    }

    @Override
    public long getFixedRate() {
        return this.userMetricsProperties.getRefreshInterval();
    }

    @Override
    public void run() {
        Map<String, UserResourcesSummary> summaries = this.jobSearchService.getUserResourcesSummaries();
        for (String user : this.usersToReset) {
            if (summaries.containsKey(user)) continue;
            this.publishUserMetrics(user, 0L, 0L);
        }
        this.usersToReset.clear();
        this.usersToReset.addAll(summaries.keySet());
        for (UserResourcesSummary userResourcesSummary : summaries.values()) {
            this.publishUserMetrics(userResourcesSummary.getUser(), userResourcesSummary.getRunningJobsCount(), userResourcesSummary.getUsedMemory());
        }
        this.registry.gauge(USER_ACTIVE_USERS_METRIC_NAME, (Number)summaries.size());
    }

    private void publishUserMetrics(@NotNull String user, long jobCount, long memoryAmount) {
        ArrayList tags = Lists.newArrayList((Object[])new Tag[]{Tag.of((String)"user", (String)user)});
        this.registry.gauge(USER_ACTIVE_JOBS_METRIC_NAME, (Iterable)tags, (Number)jobCount);
        this.registry.gauge(USER_ACTIVE_MEMORY_METRIC_NAME, (Iterable)tags, (Number)memoryAmount);
    }
}

