/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.util;

public class InspectionReport {
    private final Decision decision;
    private final String message;

    public static InspectionReport newRejection(String message) {
        return new InspectionReport(Decision.REJECT, message);
    }

    public static InspectionReport newAcceptance(String message) {
        return new InspectionReport(Decision.ACCEPT, message);
    }

    public InspectionReport(Decision decision, String message) {
        this.decision = decision;
        this.message = message;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum Decision {
        ACCEPT,
        REJECT;


        static Decision flip(Decision decision) {
            switch (decision) {
                case REJECT: {
                    return ACCEPT;
                }
                case ACCEPT: {
                    return REJECT;
                }
            }
            throw new RuntimeException("Unexpected: " + decision.name());
        }
    }
}

