/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.web.properties.AgentFilterProperties;
import com.netflix.genie.web.services.AgentFilterService;
import com.netflix.genie.web.services.impl.AgentFilterServiceImpl;
import com.netflix.genie.web.util.AgentMetadataInspector;
import com.netflix.genie.web.util.BlacklistedVersionAgentMetadataInspector;
import com.netflix.genie.web.util.MinimumVersionAgentMetadataInspector;
import com.netflix.genie.web.util.WhitelistedVersionAgentMetadataInspector;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"genie.agent.filter.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={AgentFilterProperties.class})
public class GenieAgentFilterAutoConfiguration {
    @Bean
    public AgentFilterService agentFilterService(List<AgentMetadataInspector> agentMetadataInspectorsList) {
        return new AgentFilterServiceImpl(agentMetadataInspectorsList);
    }

    @Bean
    public AgentMetadataInspector whitelistedVersionAgentMetadataInspector(AgentFilterProperties agentFilterProperties) {
        return new WhitelistedVersionAgentMetadataInspector(agentFilterProperties);
    }

    @Bean
    public AgentMetadataInspector blacklistedVersionAgentMetadataInspector(AgentFilterProperties agentFilterProperties) {
        return new BlacklistedVersionAgentMetadataInspector(agentFilterProperties);
    }

    @Bean
    public AgentMetadataInspector minimumVersionAgentMetadataInspector(AgentFilterProperties agentFilterProperties) {
        return new MinimumVersionAgentMetadataInspector(agentFilterProperties);
    }
}

