/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs;

import com.netflix.genie.web.properties.MailProperties;
import com.netflix.genie.web.services.MailService;
import com.netflix.genie.web.services.impl.DefaultMailServiceImpl;
import com.netflix.genie.web.services.impl.MailServiceImpl;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
@EnableConfigurationProperties(value={MailProperties.class})
public class GenieMailAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={JavaMailSender.class})
    public MailService getJavaMailSenderMailService(JavaMailSender javaMailSender, MailProperties genieMailProperties) {
        return new MailServiceImpl(javaMailSender, genieMailProperties.getFromAddress());
    }

    @Bean
    @ConditionalOnMissingBean(value={JavaMailSender.class})
    public MailService getDefaultMailServiceImpl() {
        return new DefaultMailServiceImpl();
    }
}

