/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.configs.aws;

import com.amazonaws.util.EC2MetadataUtils;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.configs.GenieApiAutoConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.cloud.aws.context.annotation.ConditionalOnAwsCloudEnvironment;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={ContextCredentialsAutoConfiguration.class})
@AutoConfigureBefore(value={GenieApiAutoConfiguration.class})
@ConditionalOnAwsCloudEnvironment
public class GenieAwsApiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GenieAwsApiAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={GenieHostInfo.class})
    public GenieHostInfo genieHostInfo() {
        String ec2Ipv4Address = EC2MetadataUtils.getPrivateIpAddress();
        if (StringUtils.isNotBlank((CharSequence)ec2Ipv4Address)) {
            return new GenieHostInfo(ec2Ipv4Address);
        }
        throw new IllegalStateException("Unable to resolve Genie host info");
    }
}

