/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.services;

import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.Application;
import com.netflix.genie.common.dto.Cluster;
import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.dto.search.JobSearchResult;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.web.jpa.entities.ClusterEntity;
import com.netflix.genie.web.jpa.entities.CommandEntity;
import com.netflix.genie.web.jpa.entities.JobEntity;
import com.netflix.genie.web.jpa.entities.JobEntity_;
import com.netflix.genie.web.jpa.entities.projections.AgentHostnameProjection;
import com.netflix.genie.web.jpa.entities.projections.JobApplicationsProjection;
import com.netflix.genie.web.jpa.entities.projections.JobClusterProjection;
import com.netflix.genie.web.jpa.entities.projections.JobCommandProjection;
import com.netflix.genie.web.jpa.entities.projections.JobExecutionProjection;
import com.netflix.genie.web.jpa.entities.projections.JobMetadataProjection;
import com.netflix.genie.web.jpa.entities.projections.JobProjection;
import com.netflix.genie.web.jpa.entities.projections.JobRequestProjection;
import com.netflix.genie.web.jpa.entities.projections.JobStatusProjection;
import com.netflix.genie.web.jpa.entities.projections.UniqueIdProjection;
import com.netflix.genie.web.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.web.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.web.jpa.repositories.JpaJobRepository;
import com.netflix.genie.web.jpa.services.JpaServiceUtils;
import com.netflix.genie.web.jpa.specifications.JpaJobSpecs;
import com.netflix.genie.web.services.JobSearchService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class JpaJobSearchServiceImpl
implements JobSearchService {
    private static final Logger log = LoggerFactory.getLogger(JpaJobSearchServiceImpl.class);
    private final JpaJobRepository jobRepository;
    private final JpaClusterRepository clusterRepository;
    private final JpaCommandRepository commandRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public JpaJobSearchServiceImpl(JpaJobRepository jobRepository, JpaClusterRepository clusterRepository, JpaCommandRepository commandRepository) {
        this.jobRepository = jobRepository;
        this.clusterRepository = clusterRepository;
        this.commandRepository = commandRepository;
    }

    @Override
    public Page<JobSearchResult> findJobs(@Nullable String id, @Nullable String jobName, @Nullable String user, @Nullable Set<JobStatus> statuses, @Nullable Set<String> tags, @Nullable String clusterName, @Nullable String clusterId, @Nullable String commandName, @Nullable String commandId, @Nullable Instant minStarted, @Nullable Instant maxStarted, @Nullable Instant minFinished, @Nullable Instant maxFinished, @Nullable String grouping, @Nullable String groupingInstance, @NotNull Pageable page) {
        log.debug("called");
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(JobEntity.class);
        Predicate whereClause = JpaJobSpecs.getFindPredicate((Root<JobEntity>)root, cb, id, jobName, user, statuses, tags, clusterName, clusterId == null ? null : (ClusterEntity)this.clusterRepository.findByUniqueId(clusterId).orElse(null), commandName, commandId == null ? null : (CommandEntity)this.commandRepository.findByUniqueId(commandId).orElse(null), minStarted, maxStarted, minFinished, maxFinished, grouping, groupingInstance);
        countQuery.select((Selection)cb.count((Expression)root)).where((Expression)whereClause);
        Long count = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        if (count > 0L) {
            CriteriaQuery contentQuery = cb.createQuery(JobSearchResult.class);
            contentQuery.from(JobEntity.class);
            contentQuery.multiselect(new Selection[]{root.get(JobEntity_.uniqueId), root.get(JobEntity_.name), root.get(JobEntity_.user), root.get(JobEntity_.status), root.get(JobEntity_.started), root.get(JobEntity_.finished), root.get(JobEntity_.clusterName), root.get(JobEntity_.commandName)});
            contentQuery.where((Expression)whereClause);
            Sort sort = page.getSort();
            ArrayList orders = new ArrayList();
            sort.iterator().forEachRemaining(order -> {
                if (order.isAscending()) {
                    orders.add(cb.asc((Expression)root.get(order.getProperty())));
                } else {
                    orders.add(cb.desc((Expression)root.get(order.getProperty())));
                }
            });
            contentQuery.orderBy(orders);
            List results = this.entityManager.createQuery(contentQuery).setFirstResult(Long.valueOf(page.getOffset()).intValue()).setMaxResults(page.getPageSize()).getResultList();
            return new PageImpl(results, page, count.longValue());
        }
        return new PageImpl((List)Lists.newArrayList(), page, count.longValue());
    }

    @Override
    public Set<Job> getAllActiveJobsOnHost(@NotBlank String hostname) {
        log.debug("Called with hostname {}", (Object)hostname);
        Set<JobProjection> jobs = this.jobRepository.findByAgentHostnameAndStatusIn(hostname, JobStatus.getActiveStatuses());
        return jobs.stream().map(JpaServiceUtils::toJobDto).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getAllHostsWithActiveJobs() {
        log.debug("Called");
        return this.jobRepository.findDistinctByStatusInAndV4IsFalse(JobStatus.getActiveStatuses()).stream().map(AgentHostnameProjection::getAgentHostname).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    @Override
    public Job getJob(@NotBlank(message="No id entered. Unable to get job.") @NotBlank(message="No id entered. Unable to get job.") String id) throws GenieNotFoundException {
        log.debug("Called with id {}", (Object)id);
        return JpaServiceUtils.toJobDto(this.jobRepository.findByUniqueId(id, JobProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id)));
    }

    @Override
    @Deprecated
    public JobStatus getJobStatus(@NotBlank String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return this.jobRepository.findByUniqueId(id, JobStatusProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists.")).getStatus();
    }

    @Override
    public JobRequest getJobRequest(@NotBlank String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return JpaServiceUtils.toJobRequestDto(this.jobRepository.findByUniqueId(id, JobRequestProjection.class).orElseThrow(() -> new GenieNotFoundException("No job request with id " + id)));
    }

    @Override
    public JobExecution getJobExecution(@NotBlank String id) throws GenieException {
        log.debug("Called with id {}", (Object)id);
        return JpaServiceUtils.toJobExecutionDto(this.jobRepository.findByUniqueId(id, JobExecutionProjection.class).orElseThrow(() -> new GenieNotFoundException("No job execution with id " + id)));
    }

    @Override
    public Cluster getJobCluster(@NotBlank String id) throws GenieException {
        log.debug("Called for job with id {}", (Object)id);
        return JpaServiceUtils.toClusterDto(this.jobRepository.findByUniqueId(id, JobClusterProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists. Unable to get cluster")).getCluster().orElseThrow(() -> new GenieNotFoundException("Job " + id + " doesn't have a cluster associated with it")));
    }

    @Override
    public Command getJobCommand(@NotBlank String id) throws GenieException {
        log.debug("Called for job with id {}", (Object)id);
        return JpaServiceUtils.toCommandDto(this.jobRepository.findByUniqueId(id, JobCommandProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id + " exists. Unable to get command")).getCommand().orElseThrow(() -> new GenieNotFoundException("Job " + id + " doesn't have a command associated with it")));
    }

    @Override
    public List<Application> getJobApplications(@NotBlank String id) throws GenieException {
        log.debug("Called for job with id {}", (Object)id);
        return this.jobRepository.findByUniqueId(id, JobApplicationsProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with " + id + " exists. Unable to get applications")).getApplications().stream().map(JpaServiceUtils::toApplicationDto).collect(Collectors.toList());
    }

    @Override
    public String getJobHost(@NotBlank String jobId) throws GenieNotFoundException {
        return this.jobRepository.findByUniqueId(jobId, AgentHostnameProjection.class).orElseThrow(() -> new GenieNotFoundException("No job execution found for id " + jobId)).getAgentHostname().orElseThrow(() -> new GenieNotFoundException("No hostname set for job " + jobId));
    }

    @Override
    public long getActiveJobCountForUser(@NotBlank String user) throws GenieException {
        log.debug("Called for jobs with user {}", (Object)user);
        Long count = this.jobRepository.countJobsByUserAndStatusIn(user, JobStatus.getActiveStatuses());
        if (count == null || count < 0L) {
            throw new GenieServerException("Count query for user " + user + "produced an unexpected result: " + count);
        }
        return count;
    }

    @Override
    public JobMetadata getJobMetadata(@NotBlank String id) throws GenieException {
        return JpaServiceUtils.toJobMetadataDto(this.jobRepository.findByUniqueId(id, JobMetadataProjection.class).orElseThrow(() -> new GenieNotFoundException("No job metadata found for id " + id)));
    }

    @Override
    public Map<String, UserResourcesSummary> getUserResourcesSummaries() {
        return this.jobRepository.getUserJobResourcesAggregates().stream().map(JpaServiceUtils::toUserResourceSummaryDto).collect(Collectors.toMap(UserResourcesSummary::getUser, userResourcesSummary -> userResourcesSummary));
    }

    @Override
    public Set<String> getActiveDisconnectedAgentJobs() {
        return this.jobRepository.getAgentJobIdsWithNoConnectionInState(JobStatus.getActiveStatuses()).stream().map(UniqueIdProjection::getUniqueId).collect(Collectors.toSet());
    }
}

