/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.jpa.services;

import com.netflix.genie.web.jpa.entities.TagEntity;
import com.netflix.genie.web.jpa.repositories.JpaTagRepository;
import com.netflix.genie.web.jpa.services.JpaTagPersistenceService;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class JpaTagPersistenceServiceImpl
implements JpaTagPersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaTagPersistenceServiceImpl.class);
    private final JpaTagRepository tagRepository;

    public JpaTagPersistenceServiceImpl(JpaTagRepository tagRepository) {
        this.tagRepository = tagRepository;
    }

    @Override
    public void createTagIfNotExists(@NotBlank(message="Tag cannot be blank") @NotBlank(message="Tag cannot be blank") String tag) {
        if (this.tagRepository.existsByTag(tag)) {
            return;
        }
        try {
            this.tagRepository.saveAndFlush(new TagEntity(tag));
        }
        catch (DataIntegrityViolationException e) {
            log.error("Tag expected not to be there but seems to be {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public long deleteUnusedTags(@NotNull Instant createdThreshold) {
        return this.tagRepository.deleteByIdIn(this.tagRepository.findUnusedTags(createdThreshold).stream().map(Number::longValue).collect(Collectors.toSet()));
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<TagEntity> getTag(@NotBlank(message="Tag string to find can't be blank") @NotBlank(message="Tag string to find can't be blank") String tag) {
        return this.tagRepository.findByTag(tag);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<TagEntity> getTags(@NotNull Set<String> tags) {
        return this.tagRepository.findByTagIn(tags);
    }
}

